package com.l2client.animsystem.example;


import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

import jmetest.ogrexml.TestMeshLoading;

import com.jmex.model.ogrexml.anim.MeshAnimationController;

/**
 * A GUI test for the animation system.
 * The jme ninja example is used as a base. 
 * Get sure the jme data is in your execution path!
 *
 */
public class AnimationInputTest extends TestMeshLoading {

    /*
     * (non-Javadoc)
     *
     * @see com.jme.app.SimpleGame#initGame()
     */
    protected void simpleInitGame() {
       super.simpleInitGame();
       setupScene();
    }
    
    /*
     * replace controller
     * initialize gui
     */
    private void setupScene() {

    	//TODO could use getTemplates to switch through models..
//    	Node n = Assembler2.getModel3("dwarfwarrior"); //humanhalberd"); //goblin");
//    	PartSetAnimationController con = null;
    	MeshAnimationController c = (MeshAnimationController)rootNode.getChild(0).getController(0);
    	final JMESimpleController con = new JMESimpleController(c);
//    	rootNode.getChild(0).removeController(0);
    	rootNode.getChild(0).addController(con);

    	if(con!= null ){
    		SwingUtilities.invokeLater(new Runnable() {

    			public void run() {
    				AnimationInputSwitchSidebar bar = new AnimationInputSwitchSidebar();
    				bar.setTarget(con);
    				JFrame frame = new JFrame();
    				frame.getContentPane().add(bar);
    				frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    				frame.pack();
    				frame.setVisible(true);
    			}
    		});   		
    	}
    }
    
	/**
     * Entry point
     */
    public static void main(String[] args) {
    	AnimationInputTest app = new AnimationInputTest();
        app.setConfigShowMode(ConfigShowMode.ShowIfNoConfig);
        app.start();
    }

}
