package com.l2client.animsystem.example;

import com.jme.scene.Controller;
import com.jmex.model.ogrexml.anim.MeshAnimationController;
import com.l2client.animsystem.Action;
import com.l2client.animsystem.IAnimationProvider;
import com.l2client.animsystem.InputProvider;
import com.l2client.animsystem.Mediator;
import com.l2client.animsystem.Transitions;


public class JMESimpleController extends Controller implements IAnimationProvider {
	
	private static final long serialVersionUID = 1L;
	private static final Action[] ACTIONS = new Action[] {
		new DefaultAction(),
		new AttackAction(),
		new BlockAction(),
		new ClimbAction(),
		new JumpAction(),
		new DieAction()		
	};
	private static final String[][]TRANSITIONS = new String[][]{};
	
	private Mediator mediator = new Mediator(ACTIONS, new Transitions(TRANSITIONS));
	private boolean singleStep = false;
	private MeshAnimationController internalController;
	
	
	public JMESimpleController(MeshAnimationController c) {
		mediator.setAnimationProvider(this);
		internalController = c;
	}
	
	@Override
	public void update(float tpf) {
		if(singleStep){
//			internalController.update(0f);
			mediator.update(0f);			
		} else {
//			internalController.update(tpf);
		    mediator.update(tpf);
		}
	}
	
	public void callAction(String action, InputProvider in){
		mediator.callAction(action, in);
	}
	
	public void setInput(InputProvider in) {
		mediator.setInput(in);
	}
		
	private class JMEAnimation extends com.l2client.animsystem.Animation{

		public JMEAnimation(IAnimationProvider animProvider) {
			super(animProvider);
		}

		@Override
		public Object getInternalAnimation() {
			return null; //not needed in this scenario
		}

		@Override
		public float getAnimationLength() {
			float l = internalController.getAnimationLength(getName());
			if(l<0f)
				l=0f;
			
			return l;
		}

		@Override
		public void setName(String name) {
			super.setName(name);
		}
		
	}

	@Override
	public com.l2client.animsystem.Animation createAnimation() {
		return new JMEAnimation(this);
	}

	@Override
	public void setInternalAnimation(com.l2client.animsystem.Animation anim) {
		if(anim != null){
			//Something to bend over at all? (JME does not handle setting the same animation gracefully
			if(!internalController.getActiveAnimation().equals(anim.getName())){
				internalController.setAnimation(anim.getName(), anim.getBlendTime());
				setActive(true);
				setRepeatType(anim.isLooping()?RT_WRAP:RT_CLAMP);
				setSpeed(anim.getPlayBackRate());
			}
		}
	}
}
