package com.l2client.controller.handlers;

import java.util.HashMap;
import java.util.logging.Logger;

import com.l2client.dao.DatastoreDAO;
import com.l2client.gui.GameController;
import com.l2client.model.jme.VisibleModel;
import com.l2client.model.network.EntityData;
import com.l2client.model.network.NewCharSummary;
import com.l2client.model.network.NpcData;

/**
 * Administration of npc data. An npc is every entity besides the player character. From the current player
 * other players are npcs too.
 * 
 */
//TODO implement removal of npcs (DeleteObject message from server ??) and cache clearing
public class NpcHandler extends AbstractEntityHandler {
	
	private static Logger log = Logger.getLogger(NpcHandler.class.getName());
	
	/**
	 * Internal NPC class as a wrapper for @see EntityData and @see VisibleModel
	 * Allows cross references between visual representation and back end model
	 *
	 */
	protected class Npc {
		public EntityData data;
		//FIXME change to aset usage
		public VisibleModel visual;
		public Npc(EntityData c){data = c;}
	}
	
	/**
	 * All know npc's
	 */
	HashMap<Integer, Npc> npcs = new HashMap<Integer, Npc>();


	/**
	 * Add an entity to the internal storage. Currently the visua creation of an entity is
	 * present here too which should be handled by an NpcBuilder
	 * 
	 * @param e The EntityData the npc is based on
	 */
	// TODO move generation of visual out
	public void add(EntityData e) {
		if (e.getObjectId() > 0) {
			if (e.getCharId() > 0)
				log.info("charinfo of " + e.getObjectId()
						+ " present coords are:" + e.getX() + "," + e.getY()
						+ "," + e.getZ());
			else{
				log.info("npcinfo of " + e.getObjectId()
						+ " present coords are:" + e.getX() + "," + e.getY()
						+ "," + e.getZ());
				if(e.getName()== null||e.getName().length()<=0 )
					e.setName(DatastoreDAO.getInstance().getNpcName(((NpcData)e).getTemplateId()));
			}
			Npc npc = new Npc(e);
			boolean added = false;
			synchronized (npcs) {
				if (!npcs.containsKey(e.getObjectId())) {
					npcs.put(e.getObjectId(), npc);
					added = true;
				}
			}
			if (added) {
				// TODO visual representation
				NewCharSummary n = new NewCharSummary();
				n.name = e.getName();
				VisibleModel v = new VisibleModel(n);
				v.attachVisuals();
				v.setLocalTranslation(e.getX(), e.getY(), e.getZ());
				v.updateModelBound();
				npc.visual = v;
				GameController.getInstance().getSceneRoot().getScene()
						.attachChild(v);
			}// TODO check if has to update visuals on update
		}
	}
	
	
	@Override
	public void initMoveToAction(int id, float tx, float ty, float tz){
		Npc n = npcs.get(id);
		if(n != null){
			n.visual.initMoveTo(tx,ty,tz, n.data.getSpeed());
		}
	}

	/**
	 * Lookup of EntityData for a given object id. Will return null in case the object id is not cached (not known to this client)
	 * 
	 * @param objectID object id the data should be returned for
	 * @return the EntityData for the desired object or null in case none is found
	 */
	public EntityData get(int objectID) {
		EntityData p = null;
		synchronized(npcs){
			Npc n = npcs.get(objectID);
			if(n != null)
				p = n.data;
			
		}
		return p;
	}

	public Integer[] getObjectIDs() {
		return npcs.keySet().toArray(new Integer[0]);
	}
}
