package com.l2client.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


/**
 * Central Data Store Object (DAO) for accessing the client side configuration database.
 * 
 * Mediates between internal storage an the model data.
 * 
 * Currently only fetches the NPC Names, as an example.
 *
 */
public class DatastoreDAO {

	private static DatastoreDAO instance = null;

	private DatastoreDAO() {
		ConnectionPool.getInstance();
	}
	
	public static DatastoreDAO getInstance() {
		if (instance != null)
			return instance;
		instance = new DatastoreDAO();
		return instance;
	}

	public String getNpcName(int templateID){
		String name  = "";
		Connection c = null;
		PreparedStatement st = null;
		ResultSet rs = null;
		try {
			c = ConnectionPool.getInstance().getConnection();
			st = c.prepareStatement("SELECT name FROM npc WHERE idTemplate = ?");
			st.setInt(1, templateID);
			st.execute();
			rs = st.getResultSet();
			rs.next();
			name = rs.getString(1);
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally{
			try {
				if(rs != null)
					rs.close();
				if(st != null)
					st.close();
				if(c != null)
					c.close();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return name;
	}
	
}
