package com.l2client.gui;

import java.util.ArrayList;

import com.jme.bounding.BoundingBox;
import com.jme.input.ChaseCamera;
import com.jme.input.InputHandler;
import com.jme.input.ThirdPersonHandler;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.thirdperson.ThirdPersonJoystickPlugin;
import com.jme.light.DirectionalLight;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.AxisRods;
import com.jme.scene.state.LightState;
import com.l2client.controller.SimpleTerrainManager;
import com.l2client.controller.handlers.PlayerCharHandler;
import com.l2client.gui.actions.GotoClickedInputAction;
import com.l2client.model.jme.SceneRoot;
import com.l2client.model.jme.VisibleModel;
import com.l2client.model.network.EntityData;
import com.l2client.model.network.NewCharSummary;

//TODO refactor with charselecthandler, ev. remove coupling
//FIXME too much hard coded here
//TODO move most of the functionality into seperate actions
public class CharacterController {

	private static CharacterController instance = null;
	private ChaseCamera chaser;
	private InputHandler input;
	private PointLight pl;
	private EntityData data = null;
	private VisibleModel visible = null;

	private CharacterController() {
	}

	public static CharacterController getInstance() {
		if (instance != null)
			return instance;
		else {
			instance = new CharacterController();
			return instance;
		}
	}
	
	//FIXME test and check if other actions are also disabled!
	public void setInputEnabled(boolean enable){
		if(chaser != null)
			chaser.setEnabled(enable);
		
		if(input != null)
			input.setEnabled(enable);
	}

	public void onEnterWorld(final PlayerCharHandler charSelectHandler, final EntityData entityData, Camera cam) {
		SceneRoot root = GameController.getInstance().getSceneRoot();
		Node player =root.getCharRoot();
		data = entityData;
		
		if (player != null) {
			player.detachAllChildren();

			//TODO visual representation 
			NewCharSummary n = new NewCharSummary();
			n.name = data.getName();
			visible = new VisibleModel(n);
			visible.attachVisuals();
			visible.setLocalTranslation(data.getX(), data.getY(),
					data.getZ());
			visible.updateModelBound();
//			SimpleTerrainManager.get().setCenter(entityData.getX()/SimpleTerrainManager.TERRAIN_SIZE, entityData.getY()/SimpleTerrainManager.TERRAIN_SIZE);
						
			LightState lightState = root.getLightState();
	        lightState.detachAll();

			setupChaseCamera(visible, cam);
			AxisRods rod = new AxisRods("axis", true, 1f);
			visible.attachChild(rod);
			
			//hook up of the terrain swapping @see SimpleTerrainManager
			visible.addController(new Controller(){

				private static final long serialVersionUID = 4472141781016611013L;

				@Override
				public void update(float time) {
					int x = (int)visible.getLocalTranslation().x/SimpleTerrainManager.TERRAIN_SIZE;
					int y = (int)visible.getLocalTranslation().y/SimpleTerrainManager.TERRAIN_SIZE;
					SimpleTerrainManager.get().setCenter(x, y);
					}
				}	
			);
			//FIXME move this to skydome or other environmental class
	        DirectionalLight dr = new DirectionalLight();
	        dr.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
	        dr.setAmbient(new ColorRGBA(0.7f, 0.6f, 0.6f, 1.0f));
	        dr.setSpecular(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
	        dr.setDirection(new Vector3f(30, 0 , 150));
	        dr.setEnabled(true);
	        lightState.attach(dr);
	        
	        pl = new PointLight();
	        pl.setAmbient(new ColorRGBA(0.5f,0.5f,0.5f,1));
	        pl.setDiffuse(new ColorRGBA(1,1,1,1));
	        pl.setLocation(new Vector3f(visible.getLocalTranslation().x,visible.getLocalTranslation().y, 4.0f));
	        pl.setEnabled(true);
	        lightState.attach(pl);

//			if (input == null)
//				setupInput(visible, cam);
	        setupInput2(visible, cam, charSelectHandler);
			setupJoystick();
			InputController.getInstance().pushInput(this.input);

			player.attachChild(visible);
//			root.getScene().attachChild(v);
	        

			// needed here otherwise will have dummy renderstates
			//FIXME getParent needed for lightstate :-<
			root.getScene().getParent().updateGeometricState(0, true);
			root.getScene().getParent().updateRenderState();
		}
	}

	//TODO reentrant safe, gamecontroller needed at all?
	public void initialize(GameController gameController) {
		chaser.setTarget(null);
		chaser.setCamera(null);
		
		//remove if current is used will be set later
		if(InputController.getInstance().getCurrentHandler() == input)
			InputController.getInstance().popInput();
		
		chaser = null;
		input = null;
	}

	private void setupChaseCamera(Node n, Camera cam) {
		Vector3f targetOffset = new Vector3f();
		targetOffset.z = ((BoundingBox) n.getWorldBound()).zExtent + 0.2f;
		chaser = new ChaseCamera(cam, n);
		chaser.setTargetOffset(targetOffset);
		chaser.setMaxDistance(30f);
		chaser.setMinDistance(2f);
		chaser.setWorldUpVec(Vector3f.UNIT_Z);

		chaser.getMouseLook().setLookMouseButton(0);

		//TODO test this looking around should turn the char is it correct to be here or on input setup?
//		chaser.getMouseLook().setRotateTarget(true);
	}

//	private void setupInput(Node n, Camera cam) {
//		HashMap<String, Object> handlerProps = new HashMap<String, Object>();
//		handlerProps.put(ThirdPersonHandler.PROP_DOGRADUAL, "true");
//		handlerProps.put(ThirdPersonHandler.PROP_TURNSPEED, ""
//				+ (1.0f * FastMath.PI));
//		handlerProps.put(ThirdPersonHandler.PROP_LOCKBACKWARDS, "false");
//		handlerProps.put(ThirdPersonHandler.PROP_CAMERAALIGNEDMOVE, "true");
//		ThirdPersonHandler tph = new ThirdPersonHandler(n, cam, handlerProps);
//		tph.setActionSpeed(100f);
//		input = tph;
//	}
	
	private void setupInput2(Node n, Camera cam, PlayerCharHandler charSelectHandler) {
		chaser.addAction(new GotoClickedInputAction(charSelectHandler,cam,chaser.getTarget(), 1));
		input = chaser;
	}

	private void setupJoystick() {
		ArrayList<Joystick> joys = JoystickInput.get().findJoysticksByAxis(
				"X Axis", "Y Axis", "Z Axis", "Z Rotation");
		if (joys != null) {
			Joystick joy = joys.size() >= 1 ? joys.get(0) : null;
			if (joy != null) {
				ThirdPersonJoystickPlugin plugin = new ThirdPersonJoystickPlugin(
						joy, joy.findAxis("X Axis"), joy.findAxis("Y Axis"),
						joy.findAxis("Z Axis"), joy.findAxis("Z Rotation"));
				((ThirdPersonHandler) input).setJoystickPlugin(plugin);
				chaser.getMouseLook().setJoystickPlugin(plugin);
			}
		}
	}

	/**
	 * update the chase cam stuff
	 * @param tpf
	 */
	//FIXME this should be moved out or made more intuitive to use (to have it hook up in the game update loop is not intuitive)
	public void simpleUpdate(float tpf) {
		if (chaser != null) {
			chaser.update(tpf);
			Camera cam = chaser.getCamera();
			Spatial tgt = chaser.getTarget();
			if (tgt != null) {
				float camMinHeight = tgt.getLocalTranslation().z + 0.5f;
				if (!Float.isInfinite(camMinHeight)
						&& !Float.isNaN(camMinHeight)
						&& cam.getLocation().z <= camMinHeight) {
					cam.getLocation().z = camMinHeight;
					cam.update();
				}
				if (pl != null) {
					pl.setLocation(new Vector3f(tgt.getLocalTranslation().x,
							tgt.getLocalTranslation().y, 4.0f));
				}
			}

		}
	}
	
	/**
	 * Returns the current position of the client model (!= coords in server model)
	 * 
	 * @return the current world location or the zero vector if not initialized
	 */
	public Vector3f getCurrentClientCoords(){
		if(visible != null){
			return visible.getLocalTranslation();
		} else
			return Vector3f.ZERO;
	}
	
	/**
	 * check if a char is selected and pass the visual the moveTo command
	 * @param id
	 * @param tx
	 * @param ty
	 * @param tz
	 */
	public void initMoveToAction(int id, float tx, float ty, float tz){

		if(visible != null && data != null) {
			visible.initMoveTo(tx,ty,tz, data.getSpeed());
		}
	}
}
