package com.l2client.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.Logger;

import javax.swing.JButton;
import javax.swing.SwingUtilities;

import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.input.InputHandler;
import com.jme.input.action.InputActionEvent;
import com.jme.light.PointLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.BillboardNode;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.BlendState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.BlendState.BlendEquation;
import com.jme.scene.state.BlendState.SourceFunction;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.awt.swingui.JMEAction;
import com.l2client.controller.SceneManager;
import com.l2client.controller.SoundController;
import com.l2client.gui.dialogs.CharCreateJPanel;
import com.l2client.gui.dialogs.ChatPanel;
import com.l2client.gui.dialogs.GameServerJPanel;
import com.l2client.gui.dialogs.TransparentLoginPanel;
import com.l2client.model.jme.SceneRoot;
import com.l2client.model.jme.VisibleModel;
import com.l2client.model.network.ClientFacade;
import com.l2client.model.network.GameServerInfo;
import com.l2client.model.network.NewCharSummary;
import com.l2client.network.game.ClientPackets.CharacterCreate;
import com.l2client.network.login.LoginHandler;


/**
 * game controller for switching game states;
 * start screen
 * login
 * char selection/creation
 * server selection
 * in game
 */
//FIXME check if jme gamestates could replace this
public class GameController {

	private static final Logger logger = Logger.getLogger(GameController.class
            .getName());
	
	private static GameController instance = null;
	
	private boolean finished = false;

	private ClientFacade clientInfo;

	private LoginHandler loginHandler;

	private SceneRoot sceneRoot;

	private Camera camera;
	
	private GameController(){	
	}
	
	public static GameController getInstance(){
		if(instance!= null)
			return instance;
		else{
			instance = new GameController();
			return instance;
		}
	}	
	
	public void initialize(SceneRoot root, Camera cam){
		SceneManager.get().setRoot(root);
		sceneRoot = root;
		camera = cam;
		
		Quad q = new Quad("backdrop",80.0f,60.0f);
		q.setModelBound(new OrientedBoundingBox());
		q.rotatePoints(new Quaternion().fromAngles(0, 0, (float) (0.5f*Math.PI)));
		q.setLocalTranslation(0,0,-44);
		q.updateModelBound();
		
	    TextureState ts = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
	    //Base texture, not environmental map.
	    Texture t0 = TextureManager.loadTexture(
	            this.getClass().getClassLoader().getResource(
	            "start/backdrop.png"),
	        Texture.MinificationFilter.Trilinear,
	        Texture.MagnificationFilter.Bilinear);
	    t0.setWrap(Texture.WrapMode.Repeat);
	    ts.setTexture(t0);
	    q.setRenderState(ts); 
	    q.setLightCombineMode(Spatial.LightCombineMode.Off);
	    BlendState bs = DisplaySystem.getDisplaySystem().getRenderer().createBlendState();
	    bs.setEnabled(true);
	    bs.setSourceFunctionAlpha(SourceFunction.OneMinusSourceAlpha);
	    bs.setBlendEquation(BlendEquation.Subtract);
	    bs.setTestEnabled(true);
//	    q.scaleTextureCoordinates(0, 5);
		q.setRenderState(ts);
		q.setRenderState(bs);
		BillboardNode b = new BillboardNode("somebill");
		b.setAlignment(BillboardNode.CAMERA_ALIGNED);
		b.attachChild(q);
//		sceneRoot.getScene().attachChild(b);
		sceneRoot.attachChild(b);
	}
	
	public void doEnterWorld(){
		if(sceneRoot==null)
			return;
		//reset scene
		sceneRoot.cleanupScene();
		//reset GUI
		GuiController.getInstance().removeAll();
		System.gc();
		//setup camera to be centered around player (char selecetd, or ingame object package?)
		//hook up game input controller
		CharacterController.getInstance().onEnterWorld(clientInfo.getCharSelectHandler(),clientInfo.getCharSelectHandler().getSelectedChar(), camera);
		//setup in game GUI
		setupGameGUI();
		//startup of asset loading for area around char
	}
	
	private void setupGameGUI() {
		//Chat GUI
		final InputHandler input = new InputHandler();
		final ChatPanel pan = GuiController.getInstance().displayChatJPanel(input);
		clientInfo.getChatHandler().setChatPanel(pan);
		pan.addChatListener(new KeyListener() {
			
			@Override
			public void keyTyped(KeyEvent e) {
			}
			
			@Override
			public void keyReleased(KeyEvent e) {			
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				if(KeyEvent.VK_ENTER == e.getKeyCode()){
					clientInfo.getChatHandler().sendMessage(pan.getChatMessage());
				}
			}
		});
		
		// Actions GUI
		
		// System GUI
	}

	/**
	 * Initialize the character selection based on the characters stored in the 
	 * {@link ClientFacade} CharSelectHandler
	 */
	public void doCharSelection(){
		if(sceneRoot==null)
			return;
		//reset scene
		sceneRoot.cleanupScene();
		//display available chars + gui for creation of new one
		//if none present go directly for creation of new char
        if (clientInfo.getCharSelectHandler().getCharCount() > 0) {
        	doCharPresentation();
		} else {
			doCharCreation();
		}
	}
	
	public void doCharCreation() {
		//FIXME change quickfix to a real solution for headless tests
		if(sceneRoot==null)
			return;
		//purge rootNode
		this.sceneRoot.cleanupScene();
		
		//FIXME setup camera
		
		//FIXME move to own class
		//for the first just display the menu for char selection which steers the display
		//Name, Sex, Race, Class, (HairStyle, HairColor, Face) 
		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				final InputHandler input = InputController.getInstance().getCurrentHandler();

				final CharCreateJPanel pan = GuiController.getInstance()
						.displayCharCreateJPanel(input);
				
				// action that gets executed in the update thread:
				pan.addCreateActionListener(new JMEAction("create action", input) {
							public void performAction(InputActionEvent evt) {
								// this gets executed in jme thread
								// do 3d system calls in jme thread only!
								clientInfo.sendPacket(new CharacterCreate(pan.getNewCharSummary()));
								//dialog will stay open, will be closed on
								//create ok package or cancel
								
							}
						});
				pan.addCancelActionListener(new JMEAction(
						"cancel login action", input) {

					public void performAction(InputActionEvent evt) {
						// this gets executed in jme thread
						// do 3d system calls in jme thread only!
						doCharPresentation();
					}
				});
				pan.addModelchangedListener(new JMEAction(
						"model changed action", input) {

					public void performAction(InputActionEvent evt) {
						// this gets executed in jme thread
						// do 3d system calls in jme thread only!

						//FIXME reevaluate model composition
						NewCharSummary sum = pan.getNewCharSummary();
						
						//FIXME move this out to the model package
						
//						VisibleModel v = new VisibleModel(sum);
						sceneRoot.cleanupScene();
//						sceneRoot.getScene().attachChild(v);
						VisibleModel v = new VisibleModel(sum);
						v.attachVisuals();
						v.setLocalTranslation(5f, -5f, -5f);
//						v.setLocalScale(0.03f);
						v.updateModelBound();
//						v.attachChild(new AxisRods("axis",true,1f));
						sceneRoot.getScene().attachChild(v);
						
						LightState lightState = sceneRoot.getLightState();
				        lightState.detachAll();
				        
				        PointLight pl = new PointLight();
				        pl.setAmbient(new ColorRGBA(0.5f,0.5f,0.5f,1));
				        pl.setDiffuse(new ColorRGBA(1,1,1,1));
				        pl.setLocation(new Vector3f(10,-50,20));
				        pl.setEnabled(true);
				        lightState.attach(pl);
				        
				        sceneRoot.getScene().updateGeometricState(0, true);
						// needed here otherwise will have dummy renderstates
						sceneRoot.getScene().updateRenderState();
						//FIXME end of move this out
					}
				});
				pan.afterDisplayInit();
			}
		});
		//NICE TO HAVE:
		//display x characters for x races
		//change input handler to only allow left,right, escape and enter
		//add input handler for clicking on one of the chars for selection
		//add functionality to zoom around or fade away not used chars
		//display a choose current char window on down
		//if chosen display the char customization window and an accept/cancel
		
		//exit to charPresentation on accept of a char or a cancel (if charCount > 0)
		//purge root on exit
		
	}

	/**
	 * comparable with the display of the characters in the lobby a player has for entering the world
	 */
	private void doCharPresentation() {
		if(sceneRoot==null)
			return;
		
//		{
//			// FIXME choose char and not select first, remove in product code
//			clientInfo.getCharSelectHandler().setSelected(0);
//			clientInfo.getCharSelectHandler().onCharSelected();
//			doEnterWorld();
//			if(true)return;
//		}
		
		//purge root
		this.sceneRoot.cleanupScene();
		//TODO load the hall
		//load the x representations of the characters into the hall
		//add input handler for choosing a char and functionality to let him step to the front
		//add gui buttons for enter world, exit, options
		//on enter world start game with the chosen, on exit cleanup, on options show options pane

		// getPj().charSelectHandler.showDialog();
		
		//FIXME setup camera
		
		for (int i = clientInfo.getCharSelectHandler().getCharCount()-1; i >= 0; i--) {
			VisibleModel v = new VisibleModel(clientInfo.getCharSelectHandler().getCharSummary(i));
			v.attachVisuals();
			v.setLocalTranslation(-2.5f + i * 5f, 0.0f, -5.0f
					* (float) Math.sin(0.1 * i));
//			v.setLocalScale(0.3f);
			v.updateModelBound();
			sceneRoot.getScene().attachChild(v);

		}

		LightState lightState = sceneRoot.getLightState();
        lightState.detachAll();
        
        PointLight pl = new PointLight();
        pl.setAmbient(new ColorRGBA(0.5f,0.5f,0.5f,1));
        pl.setDiffuse(new ColorRGBA(1,1,1,1));
        pl.setLocation(new Vector3f(0,-5,0));
        pl.setEnabled(true);
        lightState.attach(pl);
        
		sceneRoot.getScene().updateGeometricState(0, true);
		// needed here otherwise will have dummy renderstates
		sceneRoot.getScene().updateRenderState();
    	
		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				final DisplaySystem display = DisplaySystem.getDisplaySystem();
				// FIXME buttons + actions
				final JButton b = GuiController.getInstance().displayButton("select");
				b.setSize( b.getPreferredSize() );
				b.setLocation((display.getWidth()/2)-200, display.getHeight()-50);
				
				final JButton bb = GuiController.getInstance().displayButton("create");
				bb.setSize( b.getPreferredSize() );
				bb.setLocation((display.getWidth()/2)-200+b.getWidth()+20, display.getHeight()-50);
				
				final InputHandler input = InputController.getInstance()
						.getCurrentHandler();
				b.addActionListener(new JMEAction("select action", input) {
					public void performAction(InputActionEvent evt) {
						// FIXME choose char and not select first, remove
						clientInfo.getCharSelectHandler().setSelected(0);
						clientInfo.getCharSelectHandler().onCharSelected();
						doEnterWorld();
						//cleanup of the buttons
						GuiController.getInstance().removeButton(new JButton[]{b,bb});
					}
				});
				
				bb.addActionListener(new JMEAction("create action", input) {
					public void performAction(InputActionEvent evt) {
						doCharCreation();
					}
				});
			}
		});
	}

	public void doLogin(final InputHandler input){
		if(sceneRoot==null)
			return;
		
//		//TODO test settings for fast dev test
//		initNetwork("ghoust", new char[]{'g','h','o','u','s','t'}, input);
//		if(true)return;

		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				final TransparentLoginPanel pan = GuiController.getInstance()
						.displayUserPasswordJPanel(input);

				// action that gets executed in the update thread:
				pan.addLoginActionListener(new JMEAction("login action", input) {
							public void performAction(InputActionEvent evt) {
								// this gets executed in jme thread
								// do 3d system calls in jme thread only!
								SoundController.getInstance().playOnetime("sound/click.ogg", false, Vector3f.ZERO);
								if (!initNetwork(pan.getUsername(), pan
										.getPassword(), input)) {

									doLogin(input);
									GuiController
											.getInstance()
											.showErrorDialog(
													"Failed to Connect to login server");

								}
							}
						});
				pan.addCancelActionListener(new JMEAction(
						"cancel login action", input) {

					public void performAction(InputActionEvent evt) {
						// this gets executed in jme thread
						// do 3d system calls in jme thread only!
						finished = true;
						SoundController.getInstance().playOnetime("sound/click.ogg", false, Vector3f.ZERO);
						try {
							Thread.sleep(1500);
						} catch (InterruptedException e) {
						}
					}
				});
			}
		});
	}
	
	public boolean initNetwork(String user, char [] pwd, final InputHandler input){
		//FIXME move this out to config item
		//############################################################
		//load server properties
		Properties servers = new Properties();

        FileInputStream in;
		try {
			in = new FileInputStream("cServer.properties");
			servers.load(in);
		} catch(Exception e) {
			//FIXME elaborate
			e.printStackTrace();
			return false;
		} 

		//get startup server
		String host = servers.getProperty("client.server.host");
		Integer port = Integer.parseInt(servers.getProperty("client.server.port"));
//		String id = servers.getProperty("client.server.id");
		//if none present the open dialog to enter server info
		if(host == null || port == null){
			//TODO open window and let the user enter settings
			logger.severe("missing login server configuration in testcase");
			return false;
		}
		//#############################################################
		
		this.clientInfo = new ClientFacade(user);
		clientInfo.init();
		//try connection to login server
        this.loginHandler = new LoginHandler(port,host){
            @Override
            public void onDisconnect(boolean todoOk,String host, int port,byte[] key){
                if(todoOk){
                 	clientInfo.connectToGameServer(host,port);
                    clientInfo.playkey = key;
                }
            }
            @Override
            public void onServerListReceived(GameServerInfo[] servers){
            	
            	//FIXME for testcase use first one, remove later
//            	requestServerLogin(0);
//            	if(true) return;
            	
            	
            	//game server selection
            	if(servers != null && servers.length >0){
            		final GameServerJPanel p = GuiController.getInstance().displayServerSelectionJPanel(input, servers);
            		p.addCancelActionListener(new JMEAction(
    						"cancel server select action", input) {

    					public void performAction(InputActionEvent evt) {
    						// this gets executed in jme thread
    						// do 3d system calls in jme thread only!
    						doDisconnect(false, "", -1, null);
    						//FIXME this is just for the testcase
    						doLogin(input);
    					}
    				});
            		p.addSelectActionListener(new JMEAction(
    						"select game server action", input) {

    					public void performAction(InputActionEvent evt) {
    						// this gets executed in jme thread
    						// do 3d system calls in jme thread only!
    						requestServerLogin(p.getSelectedServer());
    					}
    				});
            	}
            	else {
            		GuiController.getInstance().showErrorDialog("Failed to Connect to login server");
            		logger.severe("Loginserver returned no gameservers to login to");
            		doDisconnect(false, "", -1, null);
            	}
            }
        };
        if(!loginHandler.connected)
        	return false;
        
        loginHandler.setLoginInfo(user,pwd);
        return true;
	}

	public final boolean isFinished() {
		return finished;
	}

	/**
	 * Top root of complete scene, including, statics, dynamics, player, etc.
	 * @return
	 */
	public SceneRoot getSceneRoot() {
		if(sceneRoot != null)
			return sceneRoot;
		else {
			//FIXME better use dummy gamecontroller triggered by injection
			logger.warning("SceneRoot requested but none set so far, please initialize first, creating DUMMY root");
			sceneRoot = new SceneRoot();
			return sceneRoot;
		}
	}
}
