package com.l2client.gui;

import java.util.Stack;

import com.jme.input.ChaseCamera;
import com.jme.input.InputHandler;

/**
 * Input controller for pushing and popping input handlers so each gui can have its own
 *
 */
public class InputController {

	private static InputController instance = null;
	private InputHandler updateInputHandler = null;
	private Stack<InputHandler> inputs = null;
	
	private InputController(){	
		inputs = new Stack<InputHandler>();
	}
	
	public static InputController getInstance(){
		if(instance!= null)
			return instance;
		else{
			instance = new InputController();
			return instance;
		}
	}
	
	/**
	 * returns the topmost input handler
	 * @return
	 */
	public InputHandler getCurrentHandler(){
		return updateInputHandler;
	}
	
	/**
	 * put an input handler on the stack, disable input of handler below
	 * @param in
	 */
	public void pushInput(InputHandler in){
		inputs.push(in);
		updateInputHandler = in;
		//HACK disable chaser if gui handler active
		if(!(in instanceof ChaseCamera))
			CharacterController.getInstance().setInputEnabled(false);
		else
			CharacterController.getInstance().setInputEnabled(true);
	}
	
	/**
	 * remove the top input handler, disable its input and enable the new one
	 * @return
	 */
	public InputHandler popInput(){
		InputHandler h = inputs.pop();
		updateInputHandler = inputs.lastElement();
		//HACK disable chaser if gui handler active
		if(updateInputHandler instanceof ChaseCamera)
			CharacterController.getInstance().setInputEnabled(true);
		else
			CharacterController.getInstance().setInputEnabled(false);
		return h;
	}

	public void setInputUpdater(InputHandler input) {
		updateInputHandler = input;
		inputs.push(input);
		pushInput(input);
	}
}
