package com.l2client.gui.actions;

import com.jme.input.MouseInput;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.MouseInputAction;
import com.jme.intersection.PickData;
import com.jme.intersection.PickResults;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.system.DisplaySystem;
import com.l2client.controller.handlers.PlayerCharHandler;
import com.l2client.gui.GameController;
import com.l2client.model.l2j.ServerCoordinates;

/**
 * Action for triggering the movement of the player. Just an example.
 * 
 *
 */
public class GotoClickedInputAction extends MouseInputAction {

	private Spatial actionTarget = null;
	private int actionButton = -1;
	private float lastTime = 0f;
	private Camera camera;
	private PlayerCharHandler handler;

	/**
	 * constructor of the action
	 * 
	 * @param charSelectHandler The PlayerCharHandler is needed to send the final move request
	 * @param cam 				The camera object
	 * @param target			The player object (target of the move)
	 * @param button			The button this action should trigger (0 is left, 1 is right, 2 is middle ...)
	 */
	//TODO refactor to be not dependant on the PlayerCharHandler
	public GotoClickedInputAction(PlayerCharHandler charSelectHandler, Camera cam, Spatial target, int button) {
		actionTarget  = target;
		actionButton = button;
		camera = cam;
		handler = charSelectHandler;
	}

	/**
	 * Execute the action, called ev. several times in a second, so we store a delay.
	 * Basically we create a lookat vector and check for intersection with the terrain tiles
	 * then the position of the intersection is passed over to the client connection to request
	 * a move to the found position (This is just the request, the confirmation is needed to trigger the real move)
	 */
	@Override
	public void performAction(InputActionEvent evt) {

		//FIXME if window has lost focus we still receive mouse button inputs!??!!
        lastTime += evt.getTime();
        if( MouseInput.get().isButtonDown(actionButton) && lastTime > 0.5f) {
//System.out.println("Button "+actionButton+" pressed");
        	lastTime = 0f;
           
            Vector2f screenPos = new Vector2f();
            // Get the position that the mouse is pointing to
            screenPos.set(MouseInput.get().getXAbsolute(), MouseInput.get().getYAbsolute());
            // Get the world location of that X,Y value
            Vector3f worldCoords = DisplaySystem.getDisplaySystem().getWorldCoordinates(screenPos, 1.0f);
            // Create a ray starting from the camera, and going in the direction
            // of the mouse's location
            final Ray ray = new Ray(camera.getLocation(), worldCoords
                    .subtractLocal(camera.getLocation()));
            ray.getDirection().normalizeLocal();
        	
        	PickResults results = new PickResults(){

				@Override
				public void addPick(Ray ray, Geometry g) {
					//process
					//TODO this is just for the testcase so we only search for quads
					if (g instanceof Quad) {
						PickData data = new PickData(ray, g, willCheckDistance());
						addPickData(data);
					} 
				}

				@Override
				public void processPick() {
					//left empty
				}
            	
            };
            results.setCheckDistance(true);
            GameController.getInstance().getSceneRoot().findPick(ray,results);
            if(results.getNumber() > 0) {
                for(int i = 0; i < results.getNumber(); i++) {
                    String name =  results.getPickData(i).getTargetMesh().getName();
                    if("bottom".equals(name)){
                    	//this is the one 
                    	        
                    	Vector3f location = ray.origin.add(ray.direction.mult(results.getPickData(i).getDistance()));
                    	System.out.println("Current loc:"+actionTarget.getLocalTranslation()+" new loc:"+location+" sent:"+
                    			(int)(1.0f/ServerCoordinates.getScaleFactor()*location.x)+","+
                    			(int)(1.0f/ServerCoordinates.getScaleFactor()*location.y)+","+
                    			(int)(1.0f/ServerCoordinates.getScaleFactor()*location.z));
                    	handler.requestMoveToAction(location.x, location.y, location.z);
                    	results.clear();
                    	return;
                    }
                }
            }

            results.clear();
        }

	}
	
	/**
	 * here you can change the button this action should be triggered by
	 * @param index to be used (should be 0 left, 1 right, 2 middle etc.)
	 */
	public void setActionButton(int index){
		actionButton = index;
	}

}
