package com.l2client.gui.dialogs;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicInternalFrameUI;

import com.jme.system.DisplaySystem;

/**
 * This is a listener
 * 
 */
public class MinMaxListener implements MouseListener {

	private Point originalPosition;
	private JInternalFrame frame;
	private JPanel min;
	private JPanel max;
	private Dimension originalSize;

	// private boolean minPlaned = false;

	public MinMaxListener(JInternalFrame frame, String label, JPanel max) {
		this.frame = frame;
		this.max = max;
		this.min = new JPanel();
		this.min = new JPanel();
		this.min.setLayout(null);
		JLabel label1 = new JLabel();
		this.min.add(label1);
		//FIXME get size from text!
		label1.setText(label);
		label1.setBounds(0, 0, 80, 20);
		min.setPreferredSize(new java.awt.Dimension(100, 25));
		min.setSize(100,25);
		min.setVisible(false);
		min.addMouseListener(this);
		switchToMini();
	}

	@Override
	public void mouseClicked(MouseEvent e) {
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		if (min.isVisible()) {
			switchToNormal();
		}
	}

	private void switchToNormal() {
		if(min.isVisible()){
		frame.setVisible(false);
		frame.remove(min);
		min.setVisible(false);
		frame.add(max);
		// show the frame again
		frame.setSize(originalSize);
		frame.setLocation(originalPosition);
		frame.pack();
		frame.setVisible(true);
//		System.out.println("MAXsize:"+frame.getSize());
		}
	}

	private void switchToMini() {

		// nuke the old frame and build a new one
		originalPosition = frame.getLocation();
		originalSize = frame.getSize();
//		System.out.println("originalsize:"+originalSize);
		frame.setVisible(false);
		frame.remove(max);
		frame.add(min);
		min.setVisible(true);

		// show the frame again
		frame.setSize(min.getWidth(),30+20);
		frame.pack();
		frame.setLocation(new Point(originalPosition.x, DisplaySystem.getDisplaySystem().getHeight() - frame.getHeight()));
		frame.setVisible(true);
//		System.out.println("MINsize:"+frame.getSize());

	}

	@Override
	public void mouseExited(MouseEvent e) {
		if (!min.isVisible()) {
			switchToMini();
		}
	}

	@Override
	public void mousePressed(MouseEvent e) {
	}

	@Override
	public void mouseReleased(MouseEvent e) {
	}

}
