package com.l2client.model;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Random;

import com.jmex.terrain.util.AbstractHeightMap;

/**
 * A simple height map which supports arbitrary sized maps
 */
public class SimpleHeightMap extends AbstractHeightMap {

	private String filename ="";
	/**
	 * standard ctor
	 */
	public SimpleHeightMap() {
		super();
	}
	
	/**
	 * creates a height map of size * size dimension, the passed height values are 
	 * used if size*size corresponds to the count of entries in the heights array, 
	 * otherwise size*size height values between -1.0 and 4.0 are created
	 * @param size		the width and depth of the height map
	 * @param heights	optional height map values for storing in the map, otherwise size*size height values between -1.0 and 4.0 are created
	 */
	public SimpleHeightMap(int size, float[] heights) {	
		if(size > 0)
			this.size = size;
		else
			return;
		
		if(heights != null && heights.length > 0 && heights.length == (size*size))		
			this.heightData = heights;
		else
			this.heightData = createDummyTerrain(size, size);
	}
	
	@Override
	public boolean load() {
		DataInputStream in = null;
		try {
			in = new DataInputStream(new FileInputStream(filename));
			int verts = in.readInt();
			size = verts;
			if(heightData != null)
				heightData = null;
			
			verts *=verts;
			heightData = new float[verts*3];
			int v = 0;
			for(int i = 0;i<verts;i++,v+=3){
				heightData[v]=in.readFloat();
				heightData[v+1]=in.readFloat();
				heightData[v+2]=in.readFloat();
			}
		} catch (Exception e) {
			size = 0;
			heightData=null;
			return false;
		}
		//int # of verts along x or z
		//array of floats (3*verts)
		return true;
	}
	
	/**
	 * creates a map of 1-50f height values of _x * _y size
	 * @param _x	x size of map
	 * @param _y	y size of map
	 * @return		the final map
	 */
	private float[] createDummyTerrain(int _x, int _y) {
		float [] map = new float[_x*_y];
		int i = 0;
		Random rand = new Random();
		for(int x = 0;x<_x;x++){
			for(int y = 0;y<_y;y++,i++){
				if(x==0 || x== _x-1||
						y==0 || y == _y-1)
					map[i] = 1.0f;
				else
					map[i] = -1.0f + rand.nextFloat()*5.0f;
			}
					
		}
		return map;
	}

	
	public String getFilename() {
		return filename;
	}

	
	public void setFilename(String name) {
		filename = name;
	}

}
