package com.l2client.model.l2j;

import com.jme.math.Vector3f;

/**
 * A central class for coordinates as understood by the server,
 * used for central coordinates scaling and conversion to the specific
 * game coordinates classes
 * 
 */
public class ServerCoordinates {

	private static float scaleFactor = .125f;
	public static Vector3f getJMEVector(float x, float y, float z){
		return new Vector3f(x*scaleFactor, y*scaleFactor, z*scaleFactor);
	}
	
	/**
	 * Sets the scalefactor the coordinates are scaled by (multiplied with)
	 * A scalefactor of 1/8 th would be 0.125 for f for example.
	 * @param f
	 */
	public static void setScaleFactor(float f){
		scaleFactor = f;
	}
	
	public static float getScaleFactor(){
		return scaleFactor;
	}
}
