package com.l2client.model.network;

import java.util.logging.Logger;

import com.l2client.controller.handlers.ChatHandler;
import com.l2client.controller.handlers.NpcHandler;
import com.l2client.controller.handlers.PlayerCharHandler;
import com.l2client.gui.CharacterController;
import com.l2client.network.game.GameHandler;
import com.l2client.network.game.ClientPackets.GameClientPacket;
import com.l2client.network.login.BaseLoginHandler;

/**
 * The ClientFacade is the controller for the network communication channels (GameHandler and LoginHandler). 
 * In Addition it is the access oint to the specific handlers, PlayerCharHandler, NpcHandler, ItemsHandler, etc.
 */
//TODO ev. think about change to static interface
public class ClientFacade {
    
	Logger log = Logger.getLogger(this.getClass().getName());
    
	//TODO change to use getter & setters
    public BaseLoginHandler loginSocket;
    public GameHandler gameSocket;
    
    //TODO change to use getter & setters
    public byte[] playkey;
    public int sessionId;
    public String accountName;


    private PlayerCharHandler charSelectHandler = new PlayerCharHandler();
	private NpcHandler npcHandler = new NpcHandler();
	private ChatHandler chatHandler = new ChatHandler();    

    public PlayerCharHandler getCharSelectHandler() {
		return charSelectHandler;
	}

	public NpcHandler getNpcHandler() {
		return npcHandler;
	}
	
	/**
	 * constructor for clientfacade to a special account
	 * @param name String representing the name of the account
	 */
    public ClientFacade(String name){
    	accountName = name;        
    	log.fine("ClientFacade created");
    }
    
    public void init(){
    	chatHandler.setClientFacade(this);
        charSelectHandler.setClientFacade(this);
        npcHandler.setClientFacade(this);
    }
    
    
    public void connectToGameServer(String host, int port){
    	log.fine("Creating connection to GameServer on host "+host+":"+port);
        gameSocket = new GameHandler(host,port);
        gameSocket.clientFacade = this;
    }

	/**
	 * perform cleanup of facade, to be called before disposing of the clientfacade
	 * shutdown of sockets
	 */
	public void cleanup(){
		if(gameSocket != null)
			gameSocket.onDisconnect();
		gameSocket = null;
		if(loginSocket != null)
			loginSocket.doDisconnect(false, null, -1, null);
		loginSocket = null;
	}

	public void sendPacket(GameClientPacket packet){
		gameSocket.sendPacketToGame(packet.getBytes());
	}

	public ChatHandler getChatHandler() {
		return this.chatHandler;		
	}
}
