package com.l2client.model.network;

/**
 * A model of the game server information, storing data like ip, port, number of
 * players, etc.
 */
public class GameServerInfo {

	/**
	 * ID of the game server
	 */
	public byte id;
	/**
	 * the ip adress string
	 */
	public String ip;

	/**
	 * the port of the game server for connections
	 */
	public int port;
	/**
	 * current number of logged in players on this game server
	 */
	public int players;
	/**
	 * number of maximum players this server supports
	 */
	public int maxplayers;
	/**
	 * flag if the server allows pvp
	 */
	public boolean pvp;
	/**
	 * is the server online?
	 */
	public boolean online;
	/**
	 * is it a test server
	 */
	public boolean test;

	public boolean brackets;

	/**
	 * Constructs a new GameServerInfo from raw byte data. must be 20 bytes at
	 * least
	 * 
	 * @param raw
	 *            raw byte information from the login server with at least 20
	 *            bytes of length
	 */
	public GameServerInfo(byte[] raw) {
		if (raw != null && raw.length >= 20) {
			id = raw[0];

			ip = ((int) raw[1] & 0xFF) + "." + ((int) raw[2] & 0xFF) + "."
					+ ((int) raw[3] & 0xFF) + "." + ((int) raw[4] & 0xFF);

			port = raw[5] & 0xff;
			port |= raw[6] << 8 & 0xff00;
			port |= raw[7] << 0x10 & 0xff0000;
			port |= raw[8] << 0x18 & 0xff000000;
			// gsi[9] & 0xff; //is currently not used age limit
			pvp = raw[10] == 0x01;
			players = raw[11] & 0xff;
			players |= raw[12] << 8 & 0xff00;
			maxplayers = raw[13] & 0xff;
			maxplayers |= raw[14] << 8 & 0xff00;
			online = raw[15] == 0x01;
			test = raw[19] == 0x04; // 4 test, 2 clock
			// gsi[20] == 0x01;//is currently not used (display brackets around
			// game server name)
		}
	}

	/**
	 * used for a short string summary of the server state
	 */
	@Override
	public String toString() {
		String g = "ip: " + ip + " free slots: " + (maxplayers - players)
				+ " online: " + online;
		return g;
	}
}
