package com.l2client.network.game.ClientPackets;

import com.l2client.model.l2j.ServerCoordinates;

/**
 * 0x0f Movement request package of client char to location, scaled down by the reverse of @see ServerCoordinates.getScaleFactor()
 * (Currently same as mult by 8)
 */
public class MoveBackwardToLocation extends GameClientPacket
{
	/**
	 * Constructor of the move package
	 * @param tx	Target x
	 * @param ty	Target y
	 * @param tz	Target z
	 * @param ox	Current x
	 * @param oy	Current y
	 * @param oz	Current z
	 * @param mouse	Mouse move of Key move (currently ignored)
	 */
	public MoveBackwardToLocation(float tx, float ty, float tz, float ox, float oy, float oz, boolean mouse)
	{
		writeC(0x0f);
		writeD((int)(1.0f/ServerCoordinates.getScaleFactor()*tx));//_targetX
		writeD((int)(1.0f/ServerCoordinates.getScaleFactor()*ty));//_targetY
		writeD((int)(1.0f/ServerCoordinates.getScaleFactor()*tz));//_targetZ
		writeD((int)(1.0f/ServerCoordinates.getScaleFactor()*ox));//_originX
		writeD((int)(1.0f/ServerCoordinates.getScaleFactor()*oy));//_originY
		writeD((int)(1.0f/ServerCoordinates.getScaleFactor()*oz));//_originZ
		writeD(1);//_moveMovement is 0 if cursor keys are used  1 if mouse is used

	}

}
