package com.l2client.network.game.ServerPackets;

import com.l2client.gui.GameController;
import com.l2client.model.l2j.ServerCoordinates;
import com.l2client.model.network.EntityData;

/**
 * Character information for the character selection scene.
 * The order of the characters resembles the slot id's for the selection later
 * Only a minimum is read at the moment
 */
//TODO elaborate
public class CharSelectionInfo extends GameServerPacket {

	@Override
	public void handlePacket() {
		log.fine("Read from Server "
				+ this.getClass().getSimpleName());

		// Number of characters available
		int size = readD();// writeD(size);

		// if 0 no new chars may be created
		readD();
		readC();

		// for each char read on
		for (int i = 0; i < size; i++) {
			EntityData ch = new EntityData();

			ch.setName(readS());
			ch.setCharId(readD());
			readS();
			int id = readD();
			if (id != getClientFacade().sessionId)
				getClientFacade().sessionId = id;
			ch.setClanId(readD());
			readD();

			ch.setSex(readD());

			ch.setRace(readD());
			ch.setClassId(readD());

			// active ??
			readD();

			ch.setX(ServerCoordinates.getScaleFactor() * readD());
			ch.setY(ServerCoordinates.getScaleFactor() * readD());
			ch.setZ(ServerCoordinates.getScaleFactor() * readD());

			ch.setCurrentHp(readF());
			ch.setCurrentMp(readF());

			ch.setSp(readD());
			ch.setExp(readQ());
			ch.setLevel(readD());

			ch.setKarma(readD());
			ch.setPkKills(readD());

			ch.setPvPKills(readD());
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();

			// FIXME TR add paperdoll support
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();
			readD();

			ch.setHairStyle(readD());
			ch.setHairColor(readD());
			ch.setFace(readD());
			ch.setMaxHp(readF());
			ch.setMaxMp(readF());
			ch.setDeleteTimer(readD());
			readD();

			// FIXME active
			readD();
			readC();
			ch.setAugmentationId(readD());
			readD();

			getClientFacade().getCharSelectHandler().addChar(ch);
		}
		GameController.getInstance().doCharSelection();

	}

}
