package com.l2client.network.game.ServerPackets;

import java.util.logging.Level;

import com.l2client.controller.handlers.AbstractEntityHandler;
import com.l2client.controller.handlers.NpcHandler;
import com.l2client.controller.handlers.PlayerCharHandler;
import com.l2client.model.l2j.ServerCoordinates;
import com.l2client.model.network.EntityData;

/**
 * Movement packet from the server, move information contains:
 *  
 * the object id of the object to be moved
 * current position vector in integer format (which will be scaled down by ServerCoordinates.getScaleFactor()
 * target position vector in integer format (which will be scaled down by ServerCoordinates.getScaleFactor()
 * 
 * 
 */
public final class MoveToLocation extends GameServerPacket
{

	/**
	 * Reads the objectId and the current and target vector and triggers a move to
	 * action (should be moved out of the clientfacade to here
	 */
	@Override
	public void handlePacket()
	{
		log.fine("Read from Server "+this.getClass().getSimpleName());
		
		//getClientFacade().triggerMoveTo(
		int objId = readD();
		float tX = ServerCoordinates.getScaleFactor()*readD();
		float tY = ServerCoordinates.getScaleFactor()*readD();
		float tZ = ServerCoordinates.getScaleFactor()*readD();
		float cX = ServerCoordinates.getScaleFactor()*readD();
		float cY = ServerCoordinates.getScaleFactor()*readD();
		float cZ = ServerCoordinates.getScaleFactor()*readD();
		
		PlayerCharHandler ch = getClientFacade().getCharSelectHandler();
		NpcHandler npc = getClientFacade().getNpcHandler();

		//TODO actually the current position cx,cy,cz is ignored this shoudl be changed
		if(tX==cX && tY == cY && tZ == cZ)
			return;
		
		EntityData n = null;
		AbstractEntityHandler h = null;
		if (objId != ch.getSelectedObjectId()) {
			// move npc
			n = npc.get(objId);
			h = npc;
		} else {
			// move pc
			n = ch.getSelectedChar();
			h = ch;
		}
		//TODO do the update triggering of the model
		if (n != null && h != null){
			if(n.equals(ch.getSelectedChar()))
				log.warning("trigger move of " + objId + " from " + cX + "," + cY
						+ "," + cZ + " to " + tX + "," + tY + "," + tZ
						+ " present coords are:" + n.getX() + "," + n.getY() + ","
						+ n.getZ());
			else
				log.fine("trigger move of " + objId + " from " + cX + "," + cY
					+ "," + cZ + " to " + tX + "," + tY + "," + tZ
					+ " present coords are:" + n.getX() + "," + n.getY() + ","
					+ n.getZ());
			
			h.initMoveToAction(objId, tX, tY, tZ);
		}
		else
			log.severe("No object found with id "+objId+" in current player "+ch.getSelectedObjectId()+" char objIds "+ch.getObjectIDs()+
					" or npcIDs "+npc.getObjectIDs());
		
	}
}
