package com.l2client.network.login;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.l2client.util.ByteUtils;

public abstract class BaseLoginHandler implements Runnable {

	private static Logger log = Logger.getLogger(BaseLoginHandler.class
			.getName());
	
	public enum LoginStatus {
		DISCONNECTED, INIT, AUTHGAMEGUARD, AUTHLOGIN, AUTHENTIFICATED
	}

	public boolean connected;
	public LoginStatus status = LoginStatus.DISCONNECTED;
	private Socket socket;

	private DataOutputStream outStream;
	private DataInputStream inStream;

	public BaseLoginHandler(Integer port, String host) {

		try {
			socket = new Socket(host, port);
			outStream = new DataOutputStream(socket.getOutputStream());
			//FIXME check and remove ev.
			outStream.flush();
			inStream = new DataInputStream(socket.getInputStream());
		} catch (EOFException excepcionEOF) {
			log.severe("Connection terminated");
			connected = false;
			return;
		} catch (IOException excepcionES) {
			log.severe("Connection failed");
			connected = false;
			return;
		}
		this.status = LoginHandler.LoginStatus.INIT;
		connected = true;
		Thread t = new Thread(this);
		t.start();

	}

	public void run() {
		 		try {
			while (connected) {
				byte[] buf = new byte[2];
				inStream.read(buf);
				int rawSize = ByteUtils.Sbyte2int(buf[0]) + ByteUtils.Sbyte2int(buf[1]) * 256;

				byte[] buf2 = new byte[rawSize];

				inStream.read(buf2, 2, rawSize - 2);

				try {
					buf2[0] = buf[0];
					buf2[1] = buf[1];
				} catch (ArrayIndexOutOfBoundsException e) {
					if (socket.isConnected()) {
						handlePacket(null);
						socket.close();
						connected = false;
					}
					log.severe("Disconnected due to array out of bounds on login packet");
					return;
				}
				handlePacket(buf2);
			}
		} catch (Exception e) {
			//exception wil be thrown alos when closing gracefully and wayting for input on the socket
			if(status != LoginStatus.DISCONNECTED && connected !=false){
			log.log(Level.SEVERE, "Connection error", e);
			connected = false;
			}
		} 
		
	}

	public void sendPacketToLogin(byte[] raw) {
		try {
			outStream.write(raw);
			outStream.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void doDisconnect(boolean todoOk, String host, int port, byte[] key) {
		onDisconnect(todoOk, host, port, key);

		connected = false;
		status = LoginStatus.DISCONNECTED;
		try {
			outStream.close();
			inStream.close();
			socket.close();
			log.info("Loginsocket closed");
		} catch (IOException ex) {
			// WE ignore this, as we want the socket to get down NOW
			log.severe("Loginsocket close failed");
		}
	}

	/**
	 * Callback called when the LoginHadler should terminate, or stop sending any longer.
	 * Should be overridden in concrete use case
	 * @param todoOk boolean flag for closing the socket (false) or only setting the internal state to disconnected (true)
	 * 				 this is used for signalling the final login procedure at the moment (true case)
	 * 
	 * @param host	 host ip of the gameserver on todoOk, null otherwise
	 * @param port	 port of the gameserver on todoOk, null otherwise
	 * @param key	 the play key to be used for the connection to the gameserver
	 */
	protected abstract void onDisconnect(boolean todoOk, String host, int port, byte[] key);
	
	protected abstract void handlePacket(byte[] raw) throws IOException;
}