package com.l2client.network.login.ServerPackets;

import com.l2client.model.network.GameServerInfo;

/**
 * Play OK received, disconnect from login server, send game key and session id to login into the gameserver
 *
 */
public class PlayOK extends LoginServerPacket {

	GameServerInfo server = null;
	byte[] sid = null;
	
	public PlayOK(GameServerInfo gameServerInfo, byte[] session) {
		server = gameServerInfo;
		sid = session;
	}

	@Override
	public void handlePacket() {
		byte[] raw = readB(8);
		byte[] gameKey = new byte[16];
		gameKey[0] = raw[4];
		gameKey[1] = raw[5];
		gameKey[2] = raw[6];
		gameKey[3] = raw[7];
		gameKey[4] = raw[0];
		gameKey[5] = raw[1];
		gameKey[6] = raw[2];
		gameKey[7] = raw[3];

		System.arraycopy(sid, 0, gameKey, 8, 8);
		loginHandler.doDisconnect(true, server.ip,
				server.port, gameKey);
	}

}
