package com.l2client.test;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.jme.app.SimpleGame;
import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.Timer;
import com.jme.util.geom.Debugger;
import com.l2client.controller.SoundController;
import com.l2client.gui.CharacterController;
import com.l2client.gui.GameController;
import com.l2client.gui.GuiController;
import com.l2client.model.jme.SceneRoot;
import com.l2client.model.network.ClientFacade;

public class TestNetLoginGui extends SimpleGame {
	
	private static final Logger logger = Logger.getLogger(TestNetLoginGui.class
            .getName());

	/**
	 * Entry point for the test,
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		TestNetLoginGui app = new TestNetLoginGui();
		app.setConfigShowMode(ConfigShowMode.ShowIfNoConfig);
		app.start();
	}

	private ClientFacade clientInfo;
//	private L2JLoginHandler loginSocket;
	private SceneRoot scene;



	/**
	 * builds the trimesh.
	 * 
	 * @see com.jme.app.SimpleGame#initGame()
	 */
	protected void simpleInitGame() {
		
		this.initGui();
		this.initScene();
		this.initSoundSystem();
	}
	
	private void initGui(){
		rootNode.setCullHint(Spatial.CullHint.Never);
		input = new InputHandler(); //new FirstPersonHandler(cam, 80, 1);
		scene = new SceneRoot();
		scene.init( lightState);
		rootNode.attachChild(scene);
		
		GuiController.getInstance().initialize(scene, input);
		GameController.getInstance().initialize(scene, cam);
		GameController.getInstance().doLogin(input);
		// show system cursor
		MouseInput.get().setCursorVisible(true);

	}
	

	private void initScene(){
//		System.out.println(System.getProperty("java.library.path"));
		display.setTitle("Logon GUI Test");
		//Our model is Z up so orient the camera properly.
//        cam.setAxes(new Vector3f(-1,0,0), new Vector3f(0,1,0), new Vector3f(0,0,1));
//        cam.setLocation(new Vector3f(0,5,-20));
		cam.setLocation(new Vector3f(20,-20,0));
		cam.lookAt(new Vector3f(0,0,0), Vector3f.UNIT_Z);
		
		FogState fs = display.getRenderer().createFogState();
		fs.setEnabled(false);
		rootNode.setRenderState(fs);		

		CullState cs = display.getRenderer().createCullState();
		cs.setCullFace(CullState.Face.Back);
		cs.setEnabled(true);

		lightState.setTwoSidedLighting(true);
		Debugger.AUTO_NORMAL_RATIO = .02f;

		((PointLight) lightState.get(0))
				.setLocation(new Vector3f(100, 500, 50));

		rootNode.setRenderState(cs);

		rootNode.setRenderQueueMode(Renderer.QUEUE_OPAQUE);
	}
	

	

	public void simpleUpdate() {
		if(GameController.getInstance().isFinished())
			finished = true;
		CharacterController.getInstance().simpleUpdate(tpf);
	}
    
    protected void cleanup() {
    	super.cleanup();
    	if(clientInfo != null)
    		clientInfo.cleanup();

    	SoundController.getInstance().cleanup();
    }
    

	@Override
    protected void initSystem() throws JmeException {
        logger.info(getVersion());
        try {
            /**
             * Get a DisplaySystem acording to the renderer selected in the
             * startup box.
             */
            display = DisplaySystem.getDisplaySystem(settings.getRenderer() );
            
            display.setMinDepthBits( depthBits );
            display.setMinStencilBits( stencilBits );
            display.setMinAlphaBits( alphaBits );
            display.setMinSamples( samples );

            /** Create a window with the startup box's information. */
            display.createWindow(settings.getWidth(), settings.getHeight(),
                    settings.getDepth(), settings.getFrequency(),
                    settings.isFullscreen() );
            logger.info("Running on: " + display.getAdapter()
                    + "\nDriver version: " + display.getDriverVersion() + "\n"
                    + display.getDisplayVendor() + " - "
                    + display.getDisplayRenderer() + " - "
                    + display.getDisplayAPIVersion());
            
            
            /**
             * Create a camera specific to the DisplaySystem that works with the
             * display's width and height
             */
            cam = display.getRenderer().createCamera( display.getWidth(),
                    display.getHeight() );

        } catch ( JmeException e ) {
            /**
             * If the displaysystem can't be initialized correctly, exit
             * instantly.
             */
            logger.log(Level.SEVERE, "Could not create displaySystem", e);
            System.exit( 1 );
        }

        /** Set a black background. */
        display.getRenderer().setBackgroundColor( ColorRGBA.black.clone() );

        /** Set up how our camera sees. */
        cameraPerspective();
        Vector3f loc = new Vector3f( 0.0f, 0.0f, 25.0f );
        Vector3f left = new Vector3f( -1.0f, 0.0f, 0.0f );
        Vector3f up = new Vector3f( 0.0f, 1.0f, 0.0f );
        Vector3f dir = new Vector3f( 0.0f, 0f, -1.0f );
        /** Move our camera to a correct place and orientation. */
        cam.setFrame( loc, left, up, dir );
        /** Signal that we've changed our camera's location/frustum. */
        cam.update();
        /** Assign the camera to this renderer. */
        display.getRenderer().setCamera( cam );

        /** Create a basic input controller. */
        FirstPersonHandler firstPersonHandler = new FirstPersonHandler( cam, 50,
                1 );
        input = firstPersonHandler;

        /** Get a high resolution timer for FPS updates. */
        timer = Timer.getTimer();

        /** Sets the title of our display. */
        String className = getClass().getName();
        if ( className.lastIndexOf( '.' ) > 0 ) className = className.substring( className.lastIndexOf( '.' )+1 );
        display.setTitle( className );

//        /** Assign key P to action "toggle_pause". */
//        KeyBindingManager.getKeyBindingManager().set( "toggle_pause",
//                KeyInput.KEY_P );
//        /** Assign key ADD to action "step". */
//        KeyBindingManager.getKeyBindingManager().set( "step",
//                KeyInput.KEY_ADD );
//        /** Assign key T to action "toggle_wire". */
//        KeyBindingManager.getKeyBindingManager().set( "toggle_wire",
//                KeyInput.KEY_T );
//        /** Assign key L to action "toggle_lights". */
//        KeyBindingManager.getKeyBindingManager().set( "toggle_lights",
//                KeyInput.KEY_L );
//        /** Assign key B to action "toggle_bounds". */
//        KeyBindingManager.getKeyBindingManager().set( "toggle_bounds",
//                KeyInput.KEY_B );
//        /** Assign key N to action "toggle_normals". */
//        KeyBindingManager.getKeyBindingManager().set( "toggle_normals",
//                KeyInput.KEY_N );
//        /** Assign key C to action "camera_out". */
//        KeyBindingManager.getKeyBindingManager().set( "camera_out",
//                KeyInput.KEY_C );
//        /** Assign key R to action "mem_report". */
//        KeyBindingManager.getKeyBindingManager().set("mem_report",
//                KeyInput.KEY_R);

        KeyBindingManager.getKeyBindingManager().set( "exit",
                KeyInput.KEY_ESCAPE );
        
        KeyBindingManager.getKeyBindingManager().set( "screen_shot",
                KeyInput.KEY_F1 );
        KeyBindingManager.getKeyBindingManager().set( "parallel_projection",
                KeyInput.KEY_F2 );
        KeyBindingManager.getKeyBindingManager().set( "toggle_depth",
                KeyInput.KEY_F3 );
        KeyBindingManager.getKeyBindingManager().set( "toggle_stats",
                KeyInput.KEY_F4 );
    }
	
	public void initSoundSystem(){
		SoundController.getInstance().playBackground( "background1", "sound/background1.ogg", true );
	}
}
