#ifndef N_MD2_H
#define N_MD2_H
//------------------------------------------------------------------------------
/**
	Header for MD2 model structures (Quake2 Models)
*/

typedef unsigned char byte;
const int MAX_TRIANGLES = 4096;
const int MAX_VERTS		= 2048;
const int MAX_FRAMES	= 512;
const int MAX_MD2SKINS	= 32;
const int MAX_SKINNAME	= 64;

struct make_index_list
{
	int a, b, c;
	float	a_s, a_t,
			b_s, b_t,
			c_s, c_t;
};

struct make_vertex_list
{
	float x, y, z;
};

struct make_frame_list
{
	make_vertex_list *vertex;
};

typedef unsigned char byte;

struct vec3_t
{
	float v[3];
};


struct dstvert_t
{
	//s and t are the positions of the skin(x,y),
	//needed to be able to switch position of skin in animation
	short s;
	short t;
};

struct dtriangle_t
{
	  short index_xyz[3];
	  short index_st[3];
};


struct dtrivertx_t
{
	byte v[3];
	byte lightnormalindex;
};

//this identifies the frames
struct daliasframe_t
{
	float scale[3];
	float translate[3];
	char name[16];
	dtrivertx_t verts[1];
};

struct SMD2Header
{
  int ident;
  int version;

  int skinwidth;			//width and height of the skin
  int skinheight;			//must be dividable by 8

  int framesize;

  int num_skins;			//number of skin textures
  int num_xyz;			
  int num_st;
  int num_tris;				//number of triangles
  int num_glcmds;
  int num_frames;			//number of total frames

  int ofs_skins;			//several offset positions
  int ofs_st;
  int ofs_tris;
  int ofs_frames;
  int ofs_glcmds; 
  int ofs_end;

} ;

typedef struct
{
		vec3_t			v;
		int				lightnormalindex;
} trivert_t;

typedef struct
{
		vec3_t          mins, maxs;
		char            name[16];
		trivert_t       v[MAX_VERTS];
} frame_t;

#endif N_MD2_H