#define N_IMPLEMENTS nMD2Ipol
//--------------------------------------------------------------------
//  nmeshnode_init.cc
//  (C) 2000 RadonLabs GmbH -- A.Weissflog
//--------------------------------------------------------------------
#include "kernel/nkernelserver.h"
#include "node/nmd2ipol.h"

nClass *nMD2Ipol::local_cl  = NULL;
nKernelServer *nMD2Ipol::ks = NULL;

extern char *nMD2Ipol_version;
extern "C" bool N_EXPORT n_init(nClass *, nKernelServer *);
extern "C" void N_EXPORT n_fini(void);
extern "C" N_EXPORT void *n_create(void);
extern "C" N_EXPORT char *n_version(void);
extern void n_initcmds(nClass *);

//--------------------------------------------------------------------
//  n_init()
//--------------------------------------------------------------------
bool N_EXPORT n_init(nClass *cl, nKernelServer *ks)
{
    nMD2Ipol::local_cl = cl;
    nMD2Ipol::ks       = ks;
    ks->AddClass("nanimnode",cl);
	n_printf("added class\n");
    n_initcmds(cl);
    return true;
}

//--------------------------------------------------------------------
//  n_fini()
//--------------------------------------------------------------------
void N_EXPORT n_fini(void)
{
    nMD2Ipol::ks->RemClass(nMD2Ipol::local_cl);
}

//--------------------------------------------------------------------
//  n_create()
//--------------------------------------------------------------------
N_EXPORT void *n_create(void)
{
    return new nMD2Ipol;
}

//--------------------------------------------------------------------
//  n_version()
//--------------------------------------------------------------------
N_EXPORT char *n_version(void)
{
    return nMD2Ipol_version;
}

//--------------------------------------------------------------------
//  EOF
//--------------------------------------------------------------------
