#--------------------------------------------------------------------
#   gendocs.tcl
#   ==========
#   Generate doxygen documentation.
#
#   13-Jan-02   leaf    created
#--------------------------------------------------------------------

if [info exists env(NOMADS_HOME)] {
	set home $env(NOMADS_HOME)
} else {
	set home [file join [file dir [info script]] .. ] }

cd $home/code/doxycfg

if [expr $argc] {
    set cfg [lindex $argv 0]
    puts "Generating docs for $cfg"
    exec 2>>doxygen.warnings doxygen $cfg
} else {
    foreach cfg [glob -nocomplain nebula*.cfg] {
        puts "Generating docs for $cfg"
        exec 2>>doxygen.warnings doxygen $cfg 
    }
}