#--------------------------------------------------------------------
#   projectedsmoke.tcl
#   ==================
#   An image projected on a wall ok smoke.
#
#--------------------------------------------------------------------

sel usr/scene

new n3dnode pos
    sel pos


    .tz -30
    .ty -30
    .tx -30

#    new nipol ry
#        sel ry
#        .connect ry
#        .addkey1f 0 0
#        .addkey1f 20 360
#    sel ..

    new nspriterender sr
        sel sr

        # the particle emitter (emits particles from vertices of a vbuffer)
        new nmeshemitter pemit
            sel pemit

            # this mesh is just a line, so that the 'smoke' forms
            # a projection walll
            new nmeshnode mesh
                sel mesh
                .setactive false
                .setreadonly true
                .setfilename "meshes/line.n3d"
            sel ..

            # particle emitter attributes... 
            .settimes 0 0 0
            .setlifetime 5
            .setfreq 100
            .setspeed 0
            .setaccel 0 3 0
            .setmeshnode mesh
        sel ..

        # particle renderer attributes...
        .setemitter pemit
        .setspin 0
        .setspinaccel 0
        .beginkeys 3
        .setkey 0 2.0 0.0 0.0 0.0 0.0 1.0
        .setkey 1 3.0 0.2 0.8 0.8 0.8 1.0
        .setkey 2 2.0 0.1 0.0 0.0 0.0 1.0
        .endkeys
    sel ..

    # the shadernode is responsible to project the image
    # on the smoke, we use 2 layers, the base layer defines
    # the "particle", the second is the projected image
    new nshadernode sn
        sel sn

        .setnumstages 2
        .setcolorop 0 "mul tex prev"
        .setcolorop 1 "mul tex prev"

        .sxyz1 0.05 0.025 0.05

        .begintunit 0
            .setaddress wrap wrap
            .setminmagfilter linear_mipmap_nearest linear
            .settexcoordsrc uv0
            .setenabletransform false
        .endtunit
        
        .begintunit 1
            .setaddress wrap wrap
            .setminmagfilter linear_mipmap_nearest linear
            .settexcoordsrc eyespace
            .setenabletransform true
        .endtunit

        .setlightenable false
        .setalphaenable true
        .setalphablend one one
        .setzwriteenable false
    sel ..

    new ntexarraynode tex
        sel tex
        .settexture 0 bmp/trees.bmp none
        .settexture 1 bmp/particle.bmp none
    sel ..
sel ..


