#
#   Nebula TEKDEMO
#
#   md2Anim
#   Does Interpolation between md2 meshes
#

proc tjump { } {
/usr/scene/mesh1/mesh.setanimation jump
/usr/scene/mesh1/mesh.setreptype oneshot 
}
proc tidle { } {
/usr/scene/mesh1/mesh.setanimation stand
/usr/scene/mesh1/mesh.setreptype loop 
}

sel    /usr/scene
source licht.tcl

new n3dnode mesh1
    sel mesh1

    .sxyz 0.075 0.075 0.075

    new nmd2ipol mesh
        sel mesh

        .setfilename "meshes/tris.md2"
	.setfps 6
	.setanimation "stand"
	.setreptype "loop"
        .setchannel "time"
        .setscale 0.5000
 
    sel ..

    new nshadernode shader
        sel shader

        .setnumstages 1
        .setcolorop 0 "mul tex prev"    

        .begintunit 0
            .setaddress wrap wrap
            .setminmagfilter linear_mipmap_linear linear
            .settexcoordsrc uv0
            .setenabletransform false
        .endtunit

        .setlightenable true
        .setdiffuse  1 1 1 1
        .setemissive 0 0 0 0
        .setambient  1 1 1 1
        .setalphaenable false

    sel ..

    new ntexarraynode tex
        sel tex
        .settexture 0 bmp/forgottenone.bmp none
    sel ..

sel ..

#new n3dnode mesh2
#    sel mesh2
#
#    .txyz 2 0 5
#    .sxyz 0.075 0.075 0.075

#    new nipol rotz
#        sel rotz
#        .connect rz
#        .addkey1f 0 0
#        .addkey1f 5 360
#    sel ..

#    new nipol rotx
#        sel rotx
#        .connect rx
#        .addkey1f 0 0
#        .addkey1f 4 360
#    sel ..

#    new nmd2ipol mesh
#        sel mesh

#        .setfilename "meshes/tris.md2"
#	.setfps 6
#	.setanimation "run"
#	.setreptype "loop"
#        .setchannel "time"
#        .setscale 0.75000
 
#    sel ..

#    new nshadernode shader
#        sel shader

#        .setnumstages 1
#        .setcolorop 0 "mul tex prev"    

#        .begintunit 0
#            .setaddress wrap wrap
#            .setminmagfilter linear_mipmap_linear linear
#            .settexcoordsrc uv0
#            .setenabletransform false
#        .endtunit

#        .setlightenable true
#        .setdiffuse  1 1 1 1
#        .setemissive 0 0 0 0
#        .setambient  1 1 1 1
#        .setalphaenable false

#    sel ..

#    new ntexarraynode tex
#        sel tex
#        .settexture 0 bmp/redone.bmp none
#    sel ..

#sel ..




sel /sys/servers/input
.beginmap
.map keyb0:ctrl.down "script:tjump"
.map keyb0:ctrl.up "script:tidle"
.map keyb0:space.down "script:/usr/scene/mesh1/mesh.setanimation run"
.map keyb0:space.up "script:/usr/scene/mesh1/mesh.setanimation stand"
.map mouse0:btn1.pressed orbit
.map mouse0:btn0.pressed pan
.map mouse0:btn2.pressed dolly
.endmap

sel /usr/scene

