#ifndef I3D_GAMEBASE_H
#define I3D_GAMEBASE_H

class Visitor;

class GameObject
{
public:
	void accept(Visitor &v){v.visit(this);};
};

class Visitor
{
public:
	virtual void visit(GameObject &b)=0;
};

class Renderable : GameObject
{
public:
	void Render(){;};
};

class RenderableVisitor : Visitor
{
public:
	void visit(Renderable &b){b.Render();};
};


#endif
