#ifndef I3D_BASEENTITY_H
#define I3D_BASEENTITY_H

#include "scene/ntransformnode.h"
#include "kernel/nref.h"

class StateMachine;
class EntityServer;
class SpherePack;
/**
	@class BaseEntity
	@ingroup 3DInfernoBase 
	
	@brief a basic entity class including messsaging and state interface
	
	- is never scaled in any direction
	- position is changed via setposition or move interface
*/
class BaseEntity :public nTransformNode 
{
friend class EntityServer;
public:
	BaseEntity();
//	BaseEntity( unsigned int id );
	~BaseEntity( void ){};

	virtual bool SaveCmds(nPersistServer *ps);
	unsigned int GetID( void )						{ return( m_ID ); }
	StateMachine* GetStateMachine( void )			{ return( m_StateMachine ); }
	void SetStateMachine( StateMachine * mch )		{ m_StateMachine = mch; }
	void Attach(nSceneServer*s,nRenderContext *rc); 
    bool HasGeometry() const{return false;};
    /// return true if node provides shader
    bool HasShader(uint fourcc) const{return false;};
    /// return true if node provides lighting information
    bool HasLight() const{return false;};
	/// set absolute position of spatial container
	void SetPosition(const vector3& p);
	/// set collision bounding radius in spatial container
	void SetRadius(float r);
	/// get collision bounding radius from spatial container
	float GetRadius(void);
	/// update intervall for associated statemachines
	void SetUpdateRate(float t){};
	/// update intervall for associated statemachines
	float GetUpdateRate(float t){return 0.0f;};
protected:
	void SetID( unsigned int id)					{ m_ID = id; }
private:
	nRef<EntityServer>	refEntServer;
	unsigned int m_ID;
	StateMachine* m_StateMachine;
	SpherePack * m_SpatialContainer;
};


#endif //I3D_BASEENTITY_H