/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */

#ifndef I3D_ENTITYMESSAGE_H
#define I3D_ENTITYMESSAGE_H

/**
	@class EntityMessage
	@ingroup 3DInfernoBase 
	@brief a basic mesage class for all entities, message types are defined here also for compile time consistency

*/

//Add new messages here
typedef enum { MSG_NULL,
			   MSG_Randomize,
			   MSG_Timeout,
			   MSG_ChangeState
} MSG_Name;

// FIXME add a priority value /high/mid/low (always proc/up to threshold /discard on high load
class EntityMessage
{
public:
	EntityMessage():m_Name(MSG_NULL),m_Sender(0),m_Receiver(0),m_State(0),m_DeliveryTime(0.0f),m_Delivered(false){};
	EntityMessage(float deliveryTime, MSG_Name name, unsigned int sender, unsigned int receiver, int state = -1 ):
	m_DeliveryTime(deliveryTime),m_Name(name),m_Sender(sender),m_Receiver(receiver),m_State(state),m_Delivered(false){};
	void Set(float deliveryTime, MSG_Name name, unsigned int sender, 
		unsigned int receiver, int state = -1 )
	{
		m_DeliveryTime=deliveryTime;
		m_Name=name;
		m_Sender=sender;
		m_Receiver=receiver;
		m_State=state;
		m_Delivered=false;
	};
	bool	operator<(const EntityMessage &n){return (m_DeliveryTime<n.m_DeliveryTime);};

	MSG_Name m_Name;		//Message name
	unsigned int m_Sender;		//Object that sent the message
	unsigned int m_Receiver;	//Object that will get the message
	int		m_State;		//State in which the receiver is allowed get the message (-1 means any state)

	float	m_DeliveryTime;	//Time at which to send the message
	bool	m_Delivered;	//Whether the message has been delivered
	//void *	m_Payload;		//Optional message data

};


#endif	// I3D_ENTITYMESSAGE_H