#ifndef I3D_ENTITYSERVER_H
#define I3D_ENTITYSERVER_H
//------------------------------------------------------------------------------
/**
    @class EntityServer
	@ingroup 3DInfernoBase 

    @brief registering of entities, converting ID's to names 
	
	@todo remove binding to spatial sorter
*/
#include "kernel/nroot.h"
#include "kernel/npersistserver.h"
#include "3di/3di_spherepackfactory.h"
#include "3di/3di_pool.h"
#include "3di/3di_baseentity.h"
#include <map>

using namespace std ;

//------------------------------------------------------------------------------
class EntityServer : public nRoot
{
public:
    /// constructor
    EntityServer();
    /// destructor
    virtual ~EntityServer();
	virtual bool SaveCmds(nPersistServer* ps);

	/// get new Entity ID
	unsigned int GetID(){return ++m_NextID;};
	inline BaseEntity * FindEntity(unsigned int ID)
	{
		map<unsigned int,BaseEntity*>::iterator ret;
		ret = m_id2ptr.find(ID);
		if(ret!= m_id2ptr.end())
			return (*ret).second;
		else
			return NULL;
	};
	BaseEntity * FindEntity(char * FullPath)
	{
		return (BaseEntity*)kernelServer->Lookup(FullPath);
	};
	unsigned int FindID(BaseEntity *obj)
	{
		map<BaseEntity*,unsigned int>::iterator ret;
		ret = m_ptr2id.find(obj);
		if(ret!= m_ptr2id.end())
			return (*ret).second;
		else
			return 0;
	};
	unsigned int FindID(const char * FullPath)
	{
		return FindID((BaseEntity*)kernelServer->Lookup(FullPath));
	};
	SpherePack * AddEntity(BaseEntity *ent)
	{
		unsigned int ret = 0;
		if(ent)
		{	
			ret = GetID();
			m_id2ptr.insert(map<unsigned int,BaseEntity*>::value_type(ret,ent));
			m_ptr2id.insert(map<BaseEntity*, unsigned int>::value_type(ent,ret));
			ent->SetID(ret);//we are friend class in base entity
			return addSpatialItem(ent);
			//return ret;
		}
		else
			return 0;
	};//insert in id 2 name list and id 2 ptr list};
	void RemEntity(BaseEntity *ent)
	{
		if(ent)
		{
			unsigned int id;
			map<BaseEntity*,unsigned int>::iterator ret;
			ret = m_ptr2id.find(ent);
			if(ret != m_ptr2id.end())
			{
				id = (*ret).second;
				m_ptr2id.erase(ret);
				m_id2ptr.erase(id);
			}
		}
	};
	void Trigger(){ m_SpatialSorter->Process();	};
	void DebugPrintEntities(){};
	//release();
private:
	map<unsigned int,BaseEntity*>				m_id2ptr;
	map<BaseEntity*, unsigned int>				m_ptr2id;
	unsigned int		m_NextID;
	SpherePackFactory * m_SpatialSorter;

	SpherePack *addSpatialItem(BaseEntity * ent)
	{
		return m_SpatialSorter->AddSphere(ent->GetPosition(),m_SpatialSorter->GetMaxLeafSize(),(void*)ent);
	};
};

//------------------------------------------------------------------------------
#endif

