#ifndef I3D_MESSAGEROUTER_H
#define I3D_MESSAGEROUTER_H
/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */

/**
	@class MessageRouter
	@ingroup 3DInfernoBase

	@brief a basic message router responsible for dispatching timed messages between the entities

*/

#include "3di/3di_entitymessage.h"
#include "3di/3di_entityserver.h"
#include "3di/3di_pool.h"
#include "3di/3di_timelist.h"
#include "kernel/nroot.h"
#include "kernel/nautoref.h"
#include "kernel/npersistserver.h"


typedef TypedNode<EntityMessage> emNode;

class MessageRouter : public nRoot
{
public:
	MessageRouter();
	~MessageRouter()
	{
		m_DelayedMessages.Clear();
	};
	virtual bool SaveCmds(nPersistServer* ps);
	void DeliverDelayedMessages( void );
	void SendMessage( float delay, MSG_Name name, unsigned int receiver, unsigned int sender, int state );
	void SendScriptMessages(float delay, int name, const char*rcver, const char*sndr, int state );
	void Trigger(){ DeliverDelayedMessages();};
	//release();
private:
	TypedList<emNode>	m_DelayedMessages;
	Pool<emNode>		m_MessagePool;
	nAutoRef<nTimeServer> refTime;
	nAutoRef<EntityServer> refEntity;
	
	void RouteMessage( EntityMessage & msg );
};

#endif	// I3D_MESSAGEROUTER_H