#ifndef I3D_SPHERE_H
#define I3D_SPHERE_H

/**
	@class Sphere
	@ingroup 3DInfernoBase
	@brief a basic sphere for spatial sorting
*/
#include "mathlib/vector.h"


/// Basic sphere for spatial positioning
class Sphere
{
public:

	Sphere();
 	Sphere(const vector3 &pos, float radius);
	
	void Set(const vector3 &pos, float radius);
	float GetRadius(void) const { return mRadius; };
	float GetSquaredRadius(void) const { return mSquared; };
	const vector3& GetPosition(void) const { return mPosition; };
	bool RayIntersection(const vector3 &rayOrigin, const vector3 &V, float distance, vector3 *intersect);
	bool RayIntersection(const vector3 &rayOrigin, const vector3 &rayDirection, vector3 *intersect);
	bool RayIntersectionInFront(const vector3 &rayOrigin, const vector3 &rayDirection, vector3 *intersect);

	void SetRadius(float radius){mRadius = radius;  mSquared = radius*radius;};

protected:
  vector3	   mPosition;
private:
  float        mRadius;
  float        mSquared; // radius squared.
};


inline Sphere::Sphere()
: mPosition(vector3(0.0f, 0.0f, 0.0f)), mRadius(0.0f), mSquared(0.0f) { };

inline Sphere::Sphere(const vector3 &center, float radius)
: mPosition(center), mRadius(radius), mSquared(radius*radius) { };

#endif
