#ifndef I3D_SPHEREPACK_H
#define I3D_SPHEREPACK_H

/**
	@class SpherePack 
	@ingroup 3DInfernoBase
	@brief a spherepack is a spatial arrangement of spheres containing sphere and holds user data at the lowest level

*/
#include "3di/3di_sphere.h"

class SpherePackFactory;

class SpherePack : public Sphere
{
public:
  SpherePack(void);
  ~SpherePack(void);
  void Init(SpherePackFactory *factory, const vector3 &pos, float radius, void *userdata); 
  void Reset(void);
  void Remove(void);

  // Sphere has a new position.
  void NewPos(const vector3 &pos);
  // Sphere has a new position and radius
  void NewPosRadius(const vector3 &pos,float radius);
  inline void * GetUserData(void) const { return mUserData; };
  inline void SetUserData(void *data) { mUserData = data; };
  inline void SetNextSibling(SpherePack *child) { mNextSibling = child; };
  inline void SetPrevSibling(SpherePack *child) { mPrevSibling = child; };
  inline SpherePack * GetNextSibling(void) const { return mNextSibling; };
  inline SpherePack * GetPrevSibling(void) const { return mPrevSibling; };

  bool Recompute(float gravy);
  void Unlink(void);
  void AddChild(SpherePack *pack);
  void LostChild(SpherePack *t);
  void SetParent(SpherePack *pack){mParent = pack;};
  SpherePack * GetParent(void){return mParent;};
  bool hasChildren(){return (mChildCount>0); };
  bool GetIntegrate(){return mIntegrate;  };
  bool GetRecompute(){return mRecompute;  };
  void SetIntegrate(bool b){mIntegrate = b;};
  void SetRecompute(bool b){mRecompute = b;};
  void PrintDebugInfo(int level);
  
private:
  SpherePack       *mParent;
  SpherePack       *mChilds;
  SpherePack       *mPrevSibling;
  SpherePack       *mNextSibling;
  float				mToParent;
  int               mChildCount; // number of children
  bool				mIntegrate;
  bool				mRecompute;
  void             *mUserData;
  SpherePackFactory *mFactory; // the factory we are a member of.
  void addAsChild(SpherePack *p);
  void addGrowChild(SpherePack *Pack,float distanceToPack);
};

#endif
