#ifndef I3D_SPHEREPACKFACTORY_H
#define I3D_SPHEREPACKFACTORY_H

/**
	@class SpherePackFactory
	@ingroup 3DInfernoBase
	@brief a factory class for spherepacks
*/

#include "3di/3di_pool.h"
#include "3di/3di_spherepack.h"
#include "util/narray.h"
//#include "util/nstack.h"
#include "mathlib/vector.h"



class SpherePackFactory
{
public:

  SpherePackFactory(int maxspheres, float rootsize, float leafsize, float gravy);
  ~SpherePackFactory(void);

  void Process(void);
  SpherePack *AddSphere(const vector3 &pos, float radius, void *userdata);

  void AddIntegrate(SpherePack *pack);          // add to the integration FIFO
  void AddRecompute(SpherePack *recompute);     // add to the recomputation (balancing) FIFO.
  void Integrate(SpherePack *pack,SpherePack *supersphere,float node_size);
  void Remove(SpherePack *pack);
  // see if any other spheres are contained within this one, if so
  // collapse them and inherit their children.

  void Reset(void);
  inline float GetMaxLeafSize(){return this->mMaxLeafSize; };
  inline float GetMaxRootSize(){return this->mMaxRootSize; };
  void PrintDebugInfo(SpherePack *p, int level);

private:

  SpherePack        *mRoot;     // 1024x1024 root node of all active spheres.
  //SpherePackCallback*mCallback;

  Pool<SpherePack>mSpheres;  //FIXME use pool for spheres.

  nArray<SpherePack*>mIntegrate; // integration fifo
  nArray<SpherePack*>mRecompute; // recomputation fifo

  float             mMaxRootSize;              // maximum size of a root node supersphere
  float             mMaxLeafSize;              // maximum size of the leaf node supersphere
  float             mSuperSphereGravy;         // binding distance gravy.
};

#endif
