#ifndef I3D_STATEMCH_H
#define I3D_STATEMCH_H

/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */

/**
	@class StateMachine
	@ingroup 3DInfernoBase
	@brief a compile time state machine encapsulated in a class
*/

#include "3di/3di_messagerouter.h"
#include "3di/3di_baseentity.h"
#include "kernel/ntimeserver.h"
#include "kernel/nautoref.h"

//State Machine Language Macros (put these keywords in the file USERTYPE.DAT in the same directory as MSDEV.EXE)
#define BeginStateMachine		if( state < 0 ) { char statename[64] = "STATE_Global"; if(0) {
#define EndStateMachine			return( true ); } } else { n_assert( 0 && "Invalid State" ); return( false ); } return( false );
#define State(a)				return( true ); } } else if( a == state ) { char statename[64] = #a; if(0) { 
#define OnMsg(a)				return( true ); } else if( EVENT_Message == event && msg && a == msg->m_Name ) { 
#define OnEvent(a)				return( true ); } else if( a == event ) { 
#define OnUpdate				OnEvent( EVENT_Update )
#define OnEnter					OnEvent( EVENT_Enter )
#define OnExit					OnEvent( EVENT_Exit )



enum StateMachineEvent { EVENT_INVALID,
						 EVENT_Update,
						 EVENT_Message,
						 EVENT_Enter,
						 EVENT_Exit
};

typedef enum { NO_MSG_SCOPING,
			   SCOPE_TO_THIS_STATE
} MSG_Scope;

/**
@todo Remove update function, each entity has a refresh interval and will be updated by messages.
*/
class StateMachine
{
public:

	StateMachine( BaseEntity * object );
	~StateMachine( void ) {}

	void Initialize( void );
	void Update( void );
	void SetState( unsigned int newState );

	void SendMsg( MSG_Name name, unsigned int receiver );
	void SendDelayedMsg( float delay, MSG_Name name, unsigned int receiver );
	void SendDelayedMsgToMe( float delay, MSG_Name name, MSG_Scope scope );

	int GetState( void )						{ return( m_currentState ); }
	float GetTimeInState( void )				{ return(0.0f);}//- m_timeOnEnter ); }				

	void SetCCReceiver( unsigned int id )			{ m_ccMessagesToGameObject = id; }
	void ClearCCReceiver( void )				{ m_ccMessagesToGameObject = 0; }
	unsigned int GetCCReceiver( void )				{ return( m_ccMessagesToGameObject ); }

	void Process( StateMachineEvent event, EntityMessage * msg );


protected:

	BaseEntity * m_Owner;


private:
	static nAutoRef<nTimeServer> refTime;
	static nAutoRef<MessageRouter> refMessage;
	unsigned int	m_currentState;
	unsigned int	m_nextState;
	bool			m_stateChange;
	float			m_timeOnEnter;
	unsigned int	m_ccMessagesToGameObject;

	virtual bool States( StateMachineEvent event, EntityMessage * msg, int state ) = 0;

};


#endif	// I3D_STATEMCH_H