#ifndef I3D_TYPEDNODE_H
#define I3D_TYPEDNODE_H
#include "kernel/ntypes.h"
//------------------------------------------------------------------------------
/**
	@class TypedNode
	@ingroup 3DInfernoBase
	@brief a not so clever linked list node
*/
template <typename DTYPE> class TypedNode
{
public:
			TypedNode(){next = prev = NULL;};
			~TypedNode()
			{
				n_assert(next == prev && next == NULL);//next = prev = NULL;
			}
	bool	operator<(const TypedNode *n){return (data<n->data);};
	bool	operator<(TypedNode *n){return (data<n->data);};
	bool	IsLinked(){return (next ||prev);};
	void	InsertAfter(TypedNode *a)
			{	
				if(a)
				{
					next = a->next;
					a->next = this;
					prev = a;
					if(next)next->prev = this;
				}
			};
	void	InsertBefore(TypedNode *b)
			{
				if(b)
				{
					prev = b->prev;
					next = b;
					b->prev = this;
					if(prev)
						prev->next = this;
				}
			};
	void	Remove()
			{
				if(prev)
				{
					prev->next = next;
				}
				if(next)
				{
					next->prev = prev;
				}
				prev = next = NULL;
			};

	TypedNode	*next;
	TypedNode	*prev;
	DTYPE		data;
};
//template <typename XTYPE> class tNode;
/**
	@class TypedList
	@ingroup 3DInfernoBase
	@brief a not so clever linked list
*/
template <typename tNode> 
class TypedList
{
public:
				TypedList(){Init();};
				~TypedList()
				{
					Clear();
					head.next = tail.prev = NULL;
				};
	bool		IsEmpty(){return !items;};
	void		Init(){Clear();};
	void		Clear()
				{
					tNode *p = GetTail();
					while((p != NULL) && (p != &head))
					{
						n_assert((p!= &head) && (p!=&tail));
						Remove(p);
						p = GetTail();
					}
					items = 0;
					head.next=&tail;tail.prev=&head;
				}
	tNode *	GetHead(){return (head.next!=&tail)?head.next:NULL;};
	tNode * GetTail(){return (tail.prev!=&head)?tail.prev:NULL;};
	void		PushBack(tNode *n){n->InsertBefore(&tail);items++;};// add to the end
	void		PushFront(tNode *n){n->InsertAfter(&head);items++;};// add in front
	void		Remove(tNode *n){
		n_assert((n!= &head) && (n!=&tail));
		n_assert(head.next != NULL && tail.prev != NULL);
		n->Remove();
		items--;
		n_assert(head.next != NULL && tail.prev != NULL);};
	void		PushSortedBack(tNode *n)
				{
					if(IsEmpty())
						PushFront(n);
					else
					{
						tNode *p = GetTail();
						// do not try to remove p!= &head as it
						while((p != NULL) && (p != &head))//should be ok to do just p!=&head other case should never happen !
						{
							if(p<n)
							{
								n_assert(p != &tail);
								n->InsertAfter(p);
								n_assert(head.next != NULL && tail.prev != NULL);
								items++;
								return;
							}
							else
								p = p->prev;
						}
						PushFront(n);
					}

				};// end of PushSortedBack
	void		PushSortedFront(tNode *n)
				{
					if(IsEmpty())
						PushFront(n);
					else
					{
						tNode *p = GetHead();
						while((p != NULL) && (p != &tail))
						{
							if(n<p)
							{
								n_assert(p != &head);
								n->InsertBefore(p);
								n_assert(head.next != NULL && tail.prev != NULL);
								items++;
								return;
							}
							else
								p = p->next;
						}
						PushBack(n);
					}

				};// end of PushSortedFront
	tNode	head;
	tNode	tail;
	unsigned int items;
};

//------------------------------------------------------------------------------
#endif
