#ifndef N_NBLENDANIMLOADER_H
#define N_NBLENDANIMLOADER_H
//------------------------------------------------------------------------------
/**
    @class nMD2Loader
	@ingroup 3DInfernoMD2ipol

    Loads a md2 (quake 2 file format) mesh file into user provided vertex and index buffers.
    
    (C) 2004 tom@3D-Inferno.com
*/
#include "gfx2/nmeshloader.h"
#include "kernel/nfile.h"
//#include "gfx2/nmesh2.h"
//#include "nmd2/3di_nmd2.h"

struct nBlendAnimations
{
	/// @todo change char name[32] to nString name
	/// an optional name for the current animation
	char name[32];  
	/// count of frame the animation consists of 
	unsigned int frames;
	/// index at which index # the frame begins (counted form 0 upwards)
	unsigned int firstframe;
	/// @todo time the transition from this frame to a different frame should play
	//float transitiontime;
};

class nBlendAnimLoader : public nMeshLoader
{
public:
    /// constructor
    nBlendAnimLoader(){};
    /// destructor
    ~nBlendAnimLoader(){};
    /// open file and read header data
    virtual bool Open(nFileServer2* fs){n_error("virtual nBlendAnimLoader::Open() called!");return false;};
    /// close the file
    virtual void Close(){n_error("virtual nBlendAnimLoader::Close() called!");};
    /// read vertex data
    virtual bool ReadVertices(void* buffer, unsigned int bufferSize){n_error("virtual nBlendAnimLoader::ReadVertices() called!");return false;};
    /// read index data
    virtual bool ReadIndices(void* buffer, unsigned int bufferSize){n_error("virtual nBlendAnimLoader::ReadIndices() called!");return false;};
    /// read edge data
    virtual bool ReadEdges(void* buffer, unsigned int bufferSize){n_error("virtual nBlendAnimLoader::ReadEdges() called!");return false;};
	/// load the animation definitions this anims will be filled and then belongs to the caller of this function. so clean it up !
	virtual bool ReadAnimations(nBlendAnimations*anims, unsigned int animoCount){n_error("virtual nBlendAnimLoader::ReadAnimations() called!");return false;};
	/// Return number of animations in file
	virtual int GetAnimationCount(){n_error("virtual nBlendAnimLoader::GetAnimatoinCount() called!");return 0;};
//	virtual int GetVertexWidth() const{};
//	virtual int GetVertexComponents() const {};
}; 


#endif