#ifndef N_NOD_H
#define N_NOD_H
//------------------------------------------------------------------------------
/**
	Header for NOD model structures (Vampire Models)
*/

struct NOD_prefix
{
	uint version;//NOD version vampire has version 7
	uint materials;//number of materials used in NOD file
};

struct NOD_Material
{
	char name[32];
};

struct NOD_Header
{
	WORD			bones;
	WORD			meshes; 
	uint			verts;		//total for all groups
	uint			faces;		//total for all groups
	WORD			meshgroups;
	uint			flags;		//bit 1 LOD struct present otherwise not
	float			bounds[6];	//bounding box 3 min 3 max floats
};

struct NOD_bones
{
	float		x;
	float		y;
	float		z;
	char		unknown1[9];
	float		unknown2[12]; //rest matrix 3*4
	signed short		siblingID;
	signed short		childID;
	signed short		parentID;
};

struct NOD_Mesh
{
	NOD_Material	name;
};

struct NOD_vertex
{
	float	vx;//vertex
	float	vy;
	float	vz;
	float	nx;//normal
	float	ny;
	float	nz;
	float	tu;//texture
	float	tv;
	float	weight;
	char	bone;
};

struct NOD_LODinfo
{
	WORD	index;
};

struct NOD_face
{
	WORD index[3];
};

struct NOD_meshgroup
{
	signed int		materialID;
	char	ignore[12];
	WORD	faces;
	WORD	vertices;
	WORD	minvertices;
	WORD	flags;//x1 LOD, x2 noweights, x4 noskinning, x8 multitexture (not used in vampire)
	char	bone;
	char	mesh;
};

#endif N_MD2_H