//------------------------------------------------------------------------------
// (c) 02-2002 Gottfried Chen
//------------------------------------------------------------------------------

#ifndef CHOPPY_WAVES_H
#define CHOPPY_WAVES_H

#include "water/statisticalwater.h"


class ChoppyWaves : public StatisticalWater
{
public:
    // Parameters:
    // - <lambda> is the choppiness scaling factor. Valuse must be negative.
    //   0 is no chopiness.
    // - The other parameters are the same as in the StatisticalWater constructor.
    //
    // For example values see StatisticalWater.
    // -0.15f is a reasonable value for <lambda>.
    //
    // @todo Check why lambda must be negative in my implementation (is this a
    // bug? I've rechecked the equations though).
    ChoppyWaves(float lambda,
                unsigned int xPower, unsigned int yPower,
                float a, const vector2& wind,
                float xWorld, float yWorld);
    
    ~ChoppyWaves();

    // <lambda> is the choppiness scaling factor.
    float getLambda() const;

    void setLambda(float);

    // Delta map in the x/z plane to generate choppy looking waves.
    const nComplex* getDeltaMapX() const;
    
    const nComplex* getDeltaMapZ() const;
	inline unsigned int getSize(){	return m_Size;}

protected:
    virtual
    void store(unsigned int index, const vector2& k, float kLen, const nComplex& result);

    virtual
    void transformToTime();

private:
    nComplex* mDeltaX;
    nComplex* mDeltaZ;
    float mLambda;
	unsigned int m_Size;
};

#endif // CHOPPY_WAVES_H
