//------------------------------------------------------------------------------
// (c) 02-2002 Gottfried Chen
//------------------------------------------------------------------------------

#ifndef GERSTNER_WAVES_H
#define GERSTNER_WAVES_H

#include "mathlib/vector.h"
#include "water/complex.h"

//#include <vector>

// Gerstner waves are not heightmap based and thus differ from the other water
// algorithms. The create a mesh directly and allow overlapping waves.
class GerstnerWaves
{
public:
    // The user takes ownership of the vertex and index arrays and has to delete
    // them afterwards with GE_DELETE_A!
    GerstnerWaves(unsigned int xSize, unsigned int ySize);
	~GerstnerWaves();

    // Time is absolute (i.e. not relative to last frame)
    void update(const double&);

    // Add a wave. <length> is the wavelength not the length of the vector k.
    // The wave vector only is used to indicate the wave direction.
    void addWave(const vector2& k, float length, float amplitude, float phase);

    
    //------------------------------------------------------------------------------
    // Mesh accessors
    //------------------------------------------------------------------------------
    
    unsigned int getVertexCount() const;
    
    vector3* getVertices();
    
    unsigned int getIndexCount() const;
    
    unsigned short* getIndices();

private:
    struct Wave
    {
        vector2 mK;
        float mLength;
        float mAmplitude;
        float mFrequency;
        float mPhase;
    };

    Wave mWaves[16];//removed vector class and switched to max 16 waves mlast shows last created wave
	int mLast;
    vector3* mVertices;
    unsigned short* mIndices;
    unsigned int mXSize;
    unsigned int mYSize;
};

#endif // GERSTNER_WAVES_H