// nComplex 

//#if     _MSC_VER > 1000
//#pragma once
//#endif

#ifndef N_COMPLEX_H
#define N_COMPLEX_H


class nComplex{
public:
	inline nComplex(void): _Re(0.0f), _Im(0.0f) {}
	inline nComplex(const float& _R, const float& _I): _Re(_R), _Im(_I) {}
//	nComplex(const nComplex& _X): _Re(_X.real()), _Im(_X.imag()) {}
	inline nComplex(const float& _R): _Re(_R){}
	inline void set(const float& _r, const float& _i){_Re=_r; _Im=_i;}

	inline nComplex* operator->(void)
	{return this;}
	inline nComplex& operator+=(const float& _X)
		{_Re = _Re + _X;return (*this); }
	inline nComplex& operator-=(const float& _X)
		{_Re = _Re - _X;return (*this); }
	inline nComplex& operator*=(const float& _X)
		{_Re = _Re * _X;_Im = _Im * _X;	return (*this); }
	inline nComplex& operator/=(const float& _X)
		{_Re = _Re / _X;_Im = _Im / _X;	return (*this); }
	inline float real(const float& _X)	{return (_Re = _X); }
	inline float imag(const float& _X)	{return (_Im = _X); }
	inline float real() const	{return (_Re); }
	inline float imag() const	{return (_Im); }

	inline nComplex& operator=(const float& _X)
		{_Re = _X;_Im = 0;return (*this); }
	inline nComplex& operator=(const nComplex& _X)
		{_Re=_X.real(); _Im=_X.imag();return (*this); }

	inline nComplex& operator+=(const nComplex& _Y)
	{_Re=(_Re + _Y.real());	_Im=(_Im + _Y.imag());
	return (*this); }
	inline nComplex& operator-=(const nComplex& _Y)
	{_Re=(_Re - _Y.real());	_Im=(_Im - _Y.imag());
	return (*this); }
	inline nComplex& operator*=(const nComplex& _Y)
	{float _Yre = _Y.real();float _Yim = _Y.imag();
	float _W = _Re * _Yre - _Im * _Yim;
	_Im =(_Re * _Yim + _Im * _Yre);	_Re = (_W);
	return (*this); }

	inline nComplex operator+(const nComplex& _R)
	{nComplex _W((*this));	return (_W += _R); }
	inline nComplex operator+(const float& _R)
	{nComplex _W(_R);_W.real(_W.real() + _Re);
	return (_W); }

	inline nComplex operator-(const nComplex& _R)
	{nComplex _W((*this));	return (_W -= _R); }
	inline nComplex operator-(const float& _R)
	{nComplex _W(_R);_W.real(_W.real() - _Re);
	return (_W); }

	inline nComplex  operator* (const nComplex& _L)const
	{nComplex _W(_L);	
	return (_W *= (*this)); }
	inline nComplex  operator* (const nComplex& _L)
	{nComplex _W(_L);	return (_W *= (*this)); }
	inline nComplex  operator*(const float& _R)
	{nComplex _W(*this);	_W.real(_W.real() * _R);
	_W.imag(_W.imag() * _R);return (_W); }
	
	inline nComplex conj()
	{return nComplex (_Re, -_Im);}
	operator nComplex*(){return (*this);	}
	nComplex & operator*(){return (*this);	}
	operator void*(){return (void*)this;	}
//	nComplex* operator->(){return (*this);	}
	nComplex& operator[](int n){return *(this[n]);	}
//#include <nComplex>
	
protected:
	float _Re, _Im;
};


#endif //N_COMPLEX_H