/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */
#include "3di/3di_entityserver.h"
#include "3di/3di_spherepack.h"
#include "3di/3di_statemachine.h"
#include "kernel/nref.h"

nNebulaScriptClass(BaseEntity, "ntransformnode");

BaseEntity::BaseEntity():
	refEntServer((EntityServer*)kernelServer->Lookup("/sys/servers/entserver")),
	m_ID(0),
	m_StateMachine(NULL)
{
		if(refEntServer.isvalid())
		{
			// entityserver set's our id 
			m_SpatialContainer = refEntServer->AddEntity(this);
		}
};

void BaseEntity::SetRadius(float r)
{
	m_SpatialContainer->NewPosRadius(GetPosition(),r);
}

float BaseEntity::GetRadius()
{
	return m_SpatialContainer->GetRadius();
}

void BaseEntity::Attach(nSceneServer*s,nRenderContext *rc)
{ 
	nTransformNode::Attach(s,rc);
	if(m_StateMachine)
		m_StateMachine->Update();
};

void BaseEntity::SetPosition(const vector3& p)
{
	nTransformNode::SetPosition(p);
	m_SpatialContainer->NewPos(p);
}
