/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */
#include "kernel/npersistserver.h"
#include "3di/3di_baseentity.h"

static void n_moveto(void* slf, nCmd* cmd);

void
n_initcmds(nClass* cl)
{
  cl->BeginCmds();
    cl->AddCmd("v_moveto_fff",   'TMOV', n_moveto);
  //  cl->AddCmd("v_moveright_v",  'RMOV', n_moveright);
  //  cl->AddCmd("v_moveaft_v",    'AMOV', n_moveaft);
  //  cl->AddCmd("v_movefro_v",    'FMOV', n_movefro);
  cl->EndCmds();
}


//------------------------------------------------------------------------------
/**
    @cmd
    setposition
    @input
    f(X), f(Y), f(Z)
    @output
    v
    @info
    Set position of node.
*/
static void
n_moveto(void* slf, nCmd* cmd)
{
    BaseEntity* self = (BaseEntity*) slf;
    vector3 v;
    v.x = cmd->In()->GetF();
    v.y = cmd->In()->GetF();
    v.z = cmd->In()->GetF();
    self->SetPosition(v);
}


bool
BaseEntity::SaveCmds(nPersistServer* ps)
{
    if (nTransformNode::SaveCmds(ps))
    {
        return true;
    }
    return false;
}
