/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */
#include "3di/3di_baseentity.h"
#include "3di/3di_statemachine.h"
#include "3di/3di_messagerouter.h"
#include "kernel/ntimeserver.h"

nNebulaScriptClass(MessageRouter, "nroot");

MessageRouter::MessageRouter():
refTime("/sys/servers/time"),
refEntity("/sys/servers/entserver")
{};

void MessageRouter::SendMessage(float delay, MSG_Name name, unsigned int receiver, unsigned int sender, int state )
{
//	return;
	if( delay <= 0.0f )
	{	//Deliver immediately
		EntityMessage msg( refTime->GetTime(), name, receiver, sender, state );
		RouteMessage( msg );
	}
	else
	{	///@todo OPTIONAL Check for duplicates - then store
		//Store in delivery list
		float deliveryTime = delay + refTime->GetTime() ;
		emNode *msg = m_MessagePool.GetNext();
		msg->data.Set(deliveryTime, name, receiver, sender, state );
		//m_delayedMessages.push_back( msg );
		m_DelayedMessages.PushSortedBack(msg);
	}
}


void MessageRouter::DeliverDelayedMessages( void )
{
//	return;

	emNode *next = m_DelayedMessages.GetHead();

	while(next != NULL)//m_DelayedMessages.GetTail())
	{
		if(next->data.m_DeliveryTime <=  refTime->GetTime())
		{
			RouteMessage(next->data);
			m_DelayedMessages.Remove(next);//unlink from delayed
			//n_delete next;
			m_MessagePool.Release(next);//release back to pool
		}
		else
		{
		//	n_printf("Messages: %d",m_DelayedMessages.items);
			return;
		}
		next = m_DelayedMessages.GetHead();
	}

}

void MessageRouter::SendScriptMessages(float delay, int name, const char*rcver, const char*sndr, int state )
{
//	return;

	unsigned int receiver;
	unsigned int sender;

	
	receiver = refEntity->FindID(rcver);
	sender = refEntity->FindID(sndr);
	
	if( delay <= 0.0f )
	{	//Deliver immediately
		EntityMessage msg( refTime->GetTime(), (MSG_Name)name, receiver, sender, state );
		RouteMessage( msg );
	}
	else
	{	///@todo OPTIONAL Check for duplicates - then store
		//Store in delivery list
		float deliveryTime = delay + refTime->GetTime() ;
		emNode *msg = m_MessagePool.GetNext();
		msg->data.Set(deliveryTime, (MSG_Name)name, receiver, sender, state );
		//m_delayedMessages.push_back( msg );
		m_DelayedMessages.PushSortedBack(msg);
	}
}

void MessageRouter::RouteMessage(EntityMessage& msg )
{
	BaseEntity * ent = refEntity->FindEntity(msg.m_Receiver);
	if(ent)
	{
		if(msg.m_State <0 || msg.m_State == ent->GetStateMachine()->GetState())
		{	//State was irrelevant or current state matches msg state (for msg scoping)
			msg.m_Delivered = true;
			ent->GetStateMachine()->Process( EVENT_Message, &msg );
		}
	}
}

static void n_sendmsg(void* slf, nCmd* cmd);

void
n_initcmds(nClass* cl)
{
  cl->BeginCmds();
    cl->AddCmd("v_send_fissi",   'SEND', n_sendmsg);
  //  cl->AddCmd("v_moveright_v",  'RMOV', n_moveright);
  //  cl->AddCmd("v_moveaft_v",    'AMOV', n_moveaft);
  //  cl->AddCmd("v_movefro_v",    'FMOV', n_movefro);
  cl->EndCmds();
}

static void
n_sendmsg(void* slf, nCmd* cmd)
{
    MessageRouter* self = (MessageRouter*) slf;
	int type,state;
	float delay;
	//char * s,r;
	delay = cmd->In()->GetF();
	type = cmd->In()->GetI();
	const char * r=cmd->In()->GetS();
	const char * s=cmd->In()->GetS();
	state = cmd->In()->GetI(); 
    self->SendScriptMessages(delay,type,r,s,state);
			//cmd->In()->GetI(),
			//cmd->In()->GetS(),
			//cmd->In()->GetS(),
			//cmd->In()->GetI());
}


bool
MessageRouter::SaveCmds(nPersistServer* ps)
{
    if (nRoot::SaveCmds(ps))
    {
        return true;
    }
    return false;
}
