#include "3di/3di_sphere.h"
#include "mathlib/nmath.h"



void Sphere::Set(const vector3 &center, float radius)
{
	mPosition = center;
	mRadius = radius;
	mSquared = radius*radius;
}


// ray-sphere intersection test from Graphics Gems p.388
// **NOTE** There is a bug in this Graphics Gem.  If the origin
// of the ray is *inside* the sphere being tested, it reports the
// wrong intersection location.  This code has a fix for the bug.
bool Sphere::RayIntersection(const vector3 &rayOrigin,const vector3 &dir,vector3 *intersect)
{
	//notation:
	//point E  = rayOrigin
	//point O  = sphere center

	vector3 EO = mPosition - rayOrigin;
	vector3 V = dir;
	float dist2 = EO.x*EO.x + EO.y*EO.y + EO.z * EO.z;
	// Bug Fix For Gem, if origin is *inside* the sphere, invert the
	// direction vector so that we get a valid intersection location.
	if ( dist2 < mSquared ) V*=-1;

	float v = EO%V;
	float disc = mSquared - (EO.lensquared() - v*v);

	if (disc > 0.0f)
	{
		if ( intersect )
		{
			float d = n_sqrt(disc);
			float dist2 = (rayOrigin-mPosition).lensquared();
			*intersect = rayOrigin + V*(v-d);
		}
		return true;
	}
	return false;
}

//
bool Sphere::RayIntersection(const vector3 &rayOrigin,
							 const vector3 &V,
							 float distance,
							 vector3 *intersect)
{
	  vector3 sect;
	  bool hit = RayIntersectionInFront(rayOrigin,V,&sect);

	  if ( hit )
	  {
			float d = (rayOrigin-sect).lensquared();
			if ( d > (distance*distance) ) return false;
			if ( intersect ) *intersect = sect;
			return true;
	  }
	  return false;
}


bool Sphere::RayIntersectionInFront(const vector3 &rayOrigin,const vector3 &V,vector3 *intersect)
{
  vector3 sect;
  bool hit = RayIntersection(rayOrigin,V,&sect);

  if ( hit )
  {

    vector3 dir = sect - rayOrigin;

    float dot = dir%V;

    if ( dot >= 0  ) // then it's in front!
    {
      if ( intersect ) *intersect = sect;
      return true;
    }
  }
  return false;
}

