#include "3di/3di_spherepackfactory.h"
#include "util/narray.h"

SpherePackFactory::SpherePackFactory(int maxspheres, /// @todo not used !
									 float rootsize,
									 float leafsize,
									 float gravy):
				mMaxRootSize(rootsize),
				mMaxLeafSize(leafsize),
				mSuperSphereGravy(gravy),
				mIntegrate(50,10),
				mRecompute(50,10)
{
	SpherePack * rs = mSpheres.GetNext();
	n_assert(rs);
	rs->Set(vector3(0.0f,0.0f,0.0f), mMaxRootSize+mSuperSphereGravy);
	mRoot = rs;
};

SpherePackFactory::~SpherePackFactory(void)
{
	Reset();
}

/// recompute on all packs in fifo then integrate on all packs in sec fifo
void SpherePackFactory::Process(void)
{
	// first recompute
	for(nArray<SpherePack*>::iterator i = mRecompute.Begin(); i != mRecompute.End(); i++)
	{
		(*i)->SetRecompute(false);
		bool kill = (*i)->Recompute(mSuperSphereGravy);
		if(kill) (*i)->~SpherePack(); //FIXME RELEASE FROM POOL
		

	}
	mRecompute.Reset();

	// next reintegrate
	for(nArray<SpherePack*>::iterator j = mIntegrate.Begin(); j != mIntegrate.End(); j++)
	{

		(*j)->SetIntegrate(false);
		mRoot->AddChild(*j);
	}
	mIntegrate.Reset();
}


/// create a new sphere, add it for integration and return it
SpherePack * SpherePackFactory::AddSphere(const vector3 &pos,
                                          float radius,
                                          void *userdata)
{
	// get next from pool
	SpherePack * ns = mSpheres.GetNext();

	if(ns)
	{	
		ns->Init(this,pos,radius+mSuperSphereGravy,userdata);
		
		AddIntegrate(ns);
		return ns;
	}

	return NULL;
}

/// add pack to integration fifo if not already inside
void SpherePackFactory::AddIntegrate(SpherePack *pack)
{
//	SpherePack
	if(! pack->GetIntegrate())
	{
		mIntegrate.Append(pack);
		pack->SetIntegrate(true);
	}
}

/// add pack to recomputation fifo if not already inside
void SpherePackFactory::AddRecompute(SpherePack *recompute)
{
	if(! recompute->GetRecompute())
	{
		if(recompute->hasChildren() || recompute->GetUserData())
		{
			mRecompute.Append(recompute);
			recompute->SetRecompute(true);
		}
		else
		{
			Remove(recompute);	
		}
	}
}

///dummy debug
//void SpherePackFactory::Render(void)
//{
//}

/// remove this one from the pool
void SpherePackFactory::Remove(SpherePack *pack)
{
	// no parent
	if(!pack->GetParent())
		return;

	pack->Remove();

	mSpheres.Release(pack);
}

/// not realy needed, or is it ?
void SpherePackFactory::Integrate(SpherePack *pack,
                                  SpherePack *supersphere,
                                  float node_size)
{
}

void SpherePackFactory::PrintDebugInfo(SpherePack *p, int level)
{
	mRoot->PrintDebugInfo(0);
}


//void SpherePackFactory::FrustumTest(const Frustum &f,SpherePackCallback *callback)
//{
  // test case here, just traverse children.
//}

/*
void SpherePackFactory::RayTrace(const vector3 &p1,
                                 const vector3 &p2,
                                 SpherePackCallback *callback)
{
  // test case here, just traverse children.
}

void SpherePackFactory::RayTraceCallback(const vector3 &p1,          // source pos of ray
                              const vector3 &dir,          // direction of ray
                              float distance,                      // distance of ray
             	  						  const vector3 &sect,          // intersection location
                              SpherePack *sphere)
{

};


void SpherePackFactory::RangeTest(const vector3 &center,float radius,SpherePackCallback *callback)
{

}


void SpherePackFactory::RangeTestCallback(const vector3 &p,float distance,SpherePack *sphere,ViewState state)
{

};
*/

void SpherePackFactory::Reset(void)
{
	//clean mroot or not ?
	mIntegrate.Reset();
	mRecompute.Reset();
	mSpheres.Clear();
}

//void SpherePackFactory::VisibilityCallback(const Frustum &f,SpherePack *sphere,ViewState state)
//{
//}
