#define N_IMPLEMENTS nBlendMeshNode
//-------------------------------------------------------------------
//  nmeshnode_cmds.cc
//  (C) 2000 RadonLabs GmbH -- A.Weissflog
//-------------------------------------------------------------------
#include "anim/3di_nblendmeshnode.h"
#include "kernel/npersistserver.h"
//#include "gfx/ngfxtypes.h"

static void n_setmesh(void*, nCmd*);
static void n_getmesh(void*, nCmd*);
static void n_getanimation(void*, nCmd*);
static void n_setanimation(void*, nCmd*);
static void n_getanimationcount(void*, nCmd*);
static void n_getfps(void*, nCmd*);
static void n_setfps(void*, nCmd*);
static void n_setilod(void*, nCmd*);
static void n_getilod(void*, nCmd*);
static void n_setanimscale(void*, nCmd*);
static void n_getanimscale(void*, nCmd*);
static void n_setreptype(void*, nCmd*);
static void n_getreptype(void*, nCmd*);
static void n_setrepetition(void*, nCmd*);
static void n_getrepetition(void*, nCmd*);


//------------------------------------------------------------------------------
/**
    @scriptclass
    nBlendMeshNode

    @superclass
    nvisnode

    @classinfo
    Describe static mesh object in a visual hierarchie which
    can load itself from a Wavefront file.
*/
void n_initcmds(nClass *cl)
{
    cl->BeginCmds();
    cl->AddCmd("v_setmesh_s",			'SFLN', n_setmesh);
    cl->AddCmd("s_getmesh_v",			'GFLN', n_getmesh);
	cl->AddCmd("s_getanimation_v",		'GANN', n_getanimation);
	cl->AddCmd("v_setanimation_s",		'SANN', n_setanimation);
	cl->AddCmd("i_getanimationcount_v", 'GANC', n_getanimationcount);
	cl->AddCmd("i_getfps_v",			'GFPS', n_getfps);
	cl->AddCmd("v_setfps_i",			'SFPS', n_setfps);
	cl->AddCmd("i_getilod_v",			'GLOD', n_getilod);
	cl->AddCmd("v_setilod_i",			'SLOD', n_setilod);
	cl->AddCmd("f_getanimscale_v",		'GASC', n_getanimscale);
	cl->AddCmd("v_setanimscale_f",		'SASC', n_setanimscale);
	cl->AddCmd("i_getreptype_v",		'GRTP', n_getreptype);
	cl->AddCmd("v_setreptype_i",		'SRTP', n_setreptype);
	cl->AddCmd("s_getrepetition_v",		'GREP', n_getrepetition);
	cl->AddCmd("v_setrepetition_s",		'SREP', n_setrepetition);
    cl->EndCmds();
}

//------------------------------------------------------------------------------
/**
    @cmd
    setmesh

    @input
    s (WavefrontFilename)

    @output
    v

    @info
    Set the filename of the animation and mesh file which describes the
    mesh geometry.
*/
static void n_setmesh(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    self->SetMesh(cmd->In()->GetS());
}

//------------------------------------------------------------------------------
/**
    @cmd
    getmesh

    @input
    v

    @output
    s (WavefrontFilename)

    @info
    Get the filename of the animation and mesh file which describes the
    mesh geometry.
*/
static void n_getmesh(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetS(self->GetMesh());
}

//------------------------------------------------------------------------------
/**
    @cmd
    setanimation

    @input
    s (Animation name)

    @output
    v

    @info
    Set the name of the current animation.
*/
static void n_setanimation(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    self->SetAnimation(cmd->In()->GetS());
}

//------------------------------------------------------------------------------
/**
    @cmd
    getanimation

    @input
    v

    @output
    s (Animation name)

    @info
    Return the name of the current animation.
*/
static void n_getanimation(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetS(self->GetAnimation());
}


//------------------------------------------------------------------------------
/**
    @cmd
    getanimationcount

    @input
    v

    @output
    i (number of animations)

    @info
    Return the number of animations for this model.
*/
static void n_getanimationcount(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetI(self->GetAnimationCount());
}

//------------------------------------------------------------------------------
/**
    @cmd
    setfps

    @input
    i

    @output
    v

    @info
    Set fps at which the animation is intended to be played.
*/
static void n_setfps(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    self->SetFPS(cmd->In()->GetI());
}

//------------------------------------------------------------------------------
/**
    @cmd
    getfps

    @input
    v

    @output
    i

    @info
    Get the fps at which the animation is intended to be played.
*/
static void n_getfps(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetI(self->GetFPS());
}

static void n_setilod(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    self->SetIpolLOD(cmd->In()->GetI());
}

static void n_getilod(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetI(self->GetIpolLOD());
}

static void n_setanimscale(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    self->SetScale(cmd->In()->GetF());
}

static void n_getanimscale(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetF(self->GetScale());
}

static void n_setreptype(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    self->SetLoopType(cmd->In()->GetI());
}


static void n_getreptype(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetI(self->GetLoopType());
}

static void n_setrepetition(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
	self->SetLoopName(cmd->In()->GetS());
}

static void n_getrepetition(void *o, nCmd *cmd)
{
    nBlendMeshNode *self = (nBlendMeshNode *) o;
    cmd->Out()->SetS(self->GetLoopName());
}

//-------------------------------------------------------------------
//  SaveCmds()
//  05-Sep-00   floh    created
//-------------------------------------------------------------------
bool nBlendMeshNode::SaveCmds(nPersistServer  *fs)
{
    bool retval = false;
    if (nMaterialNode::SaveCmds(fs)) 
	{
        nCmd *cmd;
    
        //--- setfilename ---
        cmd = fs->GetCmd(this, 'SFLN');
        cmd->In()->SetS(this->GetMesh());
        fs->PutCmd(cmd);

		//--- setfps ---
        cmd = fs->GetCmd(this, 'SFPS');
        cmd->In()->SetI(this->GetFPS());
        fs->PutCmd(cmd);

		//--- setipollod ---
        cmd = fs->GetCmd(this, 'SLOD');
        cmd->In()->SetI(this->GetIpolLOD());
        fs->PutCmd(cmd);

		//--- setscale ---
        cmd = fs->GetCmd(this, 'SASC');
        cmd->In()->SetF(this->GetScale());
        fs->PutCmd(cmd);

		//--- setlooptype ---
        cmd = fs->GetCmd(this, 'SRTP');
        cmd->In()->SetI(this->GetLoopType());
        fs->PutCmd(cmd);

        retval = true;
    }
    return retval;
}

//-------------------------------------------------------------------
//  EOF
//-------------------------------------------------------------------
