#include "entities/3di_robot.h"
#include "kernel/npersistserver.h"

static void n_moveleft(void* slf, nCmd* cmd);
static void n_moveright(void* slf, nCmd* cmd);
static void n_movefro(void* slf, nCmd* cmd);
static void n_moveaft(void* slf, nCmd* cmd);

//------------------------------------------------------------------------------
/**
    @scriptclass
    robot

    @cppclass
    Robot
    
    @superclass
    baseentity

    @classinfo
    Robot description.
*/
void
n_initcmds(nClass* cl)
{
    cl->BeginCmds();
    cl->AddCmd("v_moveleft_v",   'LMOV', n_moveleft);
    cl->AddCmd("v_moveright_v",  'RMOV', n_moveright);
    cl->AddCmd("v_moveaft_v",    'AMOV', n_moveaft);
    cl->AddCmd("v_movefro_v",    'FMOV', n_movefro);
    cl->EndCmds();
}

//------------------------------------------------------------------------------
/**
    @cmd
    moveleft
    @input
    v
    @output
    v
    @info
    moveleft info.
*/
static void
n_moveleft(void* slf, nCmd* cmd)
{
    Robot* self = (Robot*) slf;
    self->MoveLeft();
}

//------------------------------------------------------------------------------
/**
    @cmd
    moveright
    @input
    v
    @output
    v
    @info
    moveright info.
*/
static void
n_moveright(void* slf, nCmd* cmd)
{
    Robot* self = (Robot*) slf;
    self->MoveRight();
}

//------------------------------------------------------------------------------
/**
    @cmd
    movefro
    @input
    v
    @output
    v
    @info
    movefro info.
*/
static void
n_movefro(void* slf, nCmd* cmd)
{
    Robot* self = (Robot*) slf;
    self->MoveFro();
}

//------------------------------------------------------------------------------
/**
    @cmd
    moveaft
    @input
    v
    @output
    v
    @info
    moveaft info.
*/
static void
n_moveaft(void* slf, nCmd* cmd)
{
    Robot* self = (Robot*) slf;
    self->MoveAft();
}

//------------------------------------------------------------------------------
/**
*/
bool 
Robot::SaveCmds(nPersistServer* ps)
{
    if (BaseEntity::SaveCmds(ps))
    {
        return true;
    }
    return false;
}
