/* 
 * "Portions Copyright (C) Steve Rabin, 2001"
 */

#include "entities/3di_staterobot.h"
#include <stdio.h>

//Add new states here
enum States { STATE_Initialize,
			  STATE_Wander,
			  STATE_Turn
};


//Note: The macro keywords can be highlighted by placing them in the file 
//USERTYPE.DAT in the same directory as MSDEV.EXE

bool StateRobot ::States( StateMachineEvent event, EntityMessage * msg, int state )
{
BeginStateMachine

	OnMsg( MSG_ChangeState ) //Default msg response (if not handled inside current state)
		m_timer--;
		n_printf("UNKNOWN State ! %d\n",state);

	///////////////////////////////////////////////////////////////
	State( STATE_Initialize )
		OnEnter
			n_printf("STATE_Initialize entered\n");
			unsigned int paper = 8;
			paper++;
			m_timer = 0;
			char test[256];
			strcpy( test, statename );
			SendDelayedMsg( 1.0f, MSG_Timeout, m_Owner->GetID() );
			SendDelayedMsgToMe( 30.0f, MSG_ChangeState, SCOPE_TO_THIS_STATE );

		OnMsg( MSG_Timeout )
			m_timer--;

		OnUpdate
			m_timer++;
			if( m_timer > 10 ) {
				SetState( STATE_Wander );
			}
			
		OnExit
			unsigned int joke = 5;
			joke++;

	
	///////////////////////////////////////////////////////////////
	State( STATE_Wander )
		OnEnter
			n_printf("STATE_Wander entered\n");
			m_timer = 0;

		OnMsg( MSG_ChangeState )
			SetState( STATE_Initialize );
	
		OnUpdate
			m_timer ++;
			if(m_timer == 2000)
				SendDelayedMsgToMe( 10.0f, MSG_ChangeState, SCOPE_TO_THIS_STATE );
			//m_Owner->MoveLeft();

EndStateMachine
}
