//#include "Precompiled.h"
//------------------------------------------------------------------------------
// (c) 02-2002 Gottfried Chen
//------------------------------------------------------------------------------

#include "water/ChoppyWaves.h"


//------------------------------------------------------------------------------
ChoppyWaves::ChoppyWaves(float lambda,
                         unsigned int xPower, unsigned int yPower,
                         float a, const vector2& wind,
                         float xWorld, float yWorld) :
//------------------------------------------------------------------------------
StatisticalWater(xPower, yPower, a, wind, xWorld, yWorld),
mLambda(lambda)
{
//n_printf("ch x %d y %d\n", xPower, yPower);
//    GE_ASSERT(lambda <= 0);
//	if(xPower  != yPower)
//		yPower = xPower;
	m_Size = xPower;
//n_printf("chopp ");
    mDeltaX = n_new(nComplex[getXSize()*getYSize()]);
    mDeltaZ = n_new(nComplex[getXSize()*getYSize()]);

//	n_printf("chopp\n");
}

//------------------------------------------------------------------------------
ChoppyWaves::~ChoppyWaves()
//------------------------------------------------------------------------------
{
//	n_printf("chopp ~\n");
    n_delete_array(mDeltaX);
    n_delete_array(mDeltaZ);
//	n_printf("chopp ~\n");
}

//------------------------------------------------------------------------------
float ChoppyWaves::getLambda() const
//------------------------------------------------------------------------------
{
    return mLambda;
}

//------------------------------------------------------------------------------
void ChoppyWaves::setLambda(float lambda)
//------------------------------------------------------------------------------
{
    //GE_ASSERT(lambda <= 0);
	if(lambda > 0)
		return;
	
    mLambda = lambda;
}

//------------------------------------------------------------------------------
const nComplex* ChoppyWaves::getDeltaMapX() const
//------------------------------------------------------------------------------
{
    return mDeltaX;
}

//------------------------------------------------------------------------------
const nComplex* ChoppyWaves::getDeltaMapZ() const
//------------------------------------------------------------------------------
{
    return mDeltaZ;
}

//------------------------------------------------------------------------------
void ChoppyWaves::store(unsigned int index, const vector2& k, float kLen,
                        const nComplex& result)
//------------------------------------------------------------------------------
{
    StatisticalWater::store(index, k, kLen, result);

    mDeltaX[index] = kLen == 0 ? 
                     0 :
                     nComplex(0.0f,-k.x/kLen)*result;

    mDeltaZ[index] = kLen == 0 ?
                     0 :
                     nComplex(0.0f,-k.y/kLen)*result;     
}

#ifdef __VC__
#pragma optimize("agt", on)
#endif
//------------------------------------------------------------------------------
void ChoppyWaves::transformToTime()
//------------------------------------------------------------------------------
{
//n_printf("choppy trans\n");
    StatisticalWater::transformToTime();

    unsigned int yLine(0);
/*	{ for (int g=getYSize(); g<getYSize()*2;g++)
//n_printf("%f",mDeltaZ[g].real());
mDeltaZ[g].real(g*0.1f);

	}
n_printf("---\n");
*//*	{
		nComplex * p =mDeltaZ;
for (int g=getYSize(); g<getYSize()*2;g++,p++)
n_printf("%f ",mDeltaZ[g].real());
//OK
	}
n_printf("---\n");
*//*	{
		nComplex *p;
		p=&mDeltaZ[32];
for (int g=getYSize(); g<getYSize()*2;g++,p++)
n_printf("%f %d ",p->imag(),p);
	}
 */   
	getFft()->calculate(mDeltaX);
    getFft()->calculate(mDeltaZ);
/*	{
		nComplex *p;
		p=&mDeltaZ[32];
for (int g=getYSize(); g<getYSize()*2;g++,p++)
n_printf("%f %d ",p->imag(),p);
	}
*/
	for (unsigned int y = 0; y<getYSize(); ++y)
    {
        yLine = y*getXSize();
        for (unsigned int x = 0; x<getXSize(); ++x)
        {
            // The neg1pow term results from shifting the sum index from [-N/2, N)
            // to [0, N)
            mDeltaX[yLine+x] *= float(neg1Pow(x+y))*mLambda;
            mDeltaZ[yLine+x] *= float(neg1Pow(x+y))*mLambda;
        }
    }
}