//#include "Precompiled.h"

//------------------------------------------------------------------------------
// (c) 02-2002 Gottfried Chen
//------------------------------------------------------------------------------

#include "water/Fft.h"
//#include <System/Base.h>


#ifdef USE_FFTW

//------------------------------------------------------------------------------
Fftw::Fftw(unsigned int sizePower, int sign)
//------------------------------------------------------------------------------
{
//    GE_ASSERT(sign == 1 || sign == -1);
    mPlan = fftw_create_plan(2<<sizePower, sign < 0 ? FFTW_FORWARD : FFTW_BACKWARD,
                             FFTW_ESTIMATE|FFTW_IN_PLACE);
}

//------------------------------------------------------------------------------
Fftw::~Fftw()
//------------------------------------------------------------------------------
{
    fftw_destroy_plan(mPlan);
}

//------------------------------------------------------------------------------
void Fftw::calculate(Complex<Float>* data) const
//------------------------------------------------------------------------------
{
    fftw_one(mPlan, reinterpret_cast<fftw_complex*>(data), 0);
}

//------------------------------------------------------------------------------
Fftw2D::Fftw2D(unsigned int xSizePower, unsigned int ySizePower, int sign)
//------------------------------------------------------------------------------
{
//    GE_ASSERT(sign == 1 || sign == -1);
    mPlan = fftw2d_create_plan(1<<ySizePower, 1<<xSizePower,
                               sign < 0 ? FFTW_FORWARD : FFTW_BACKWARD,
                               FFTW_ESTIMATE|FFTW_IN_PLACE);
}

//------------------------------------------------------------------------------
Fftw2D::~Fftw2D()
//------------------------------------------------------------------------------
{
    fftwnd_destroy_plan(mPlan);
}


//------------------------------------------------------------------------------
void Fftw2D::calculate(Complex<Float>* data) const
//------------------------------------------------------------------------------
{
    fftwnd_one(mPlan, reinterpret_cast<fftw_complex*>(data), 0);
}

#endif // USE_FFTW
