//#include "Precompiled.h"
//------------------------------------------------------------------------------
// (c) 02-2002 Gottfried Chen
//------------------------------------------------------------------------------

#include "water/GerstnerWaves.h"

#pragma warning(disable:4244)
const float G = 9.81f;

//------------------------------------------------------------------------------
GerstnerWaves::GerstnerWaves(unsigned int xSize, unsigned int ySize) :
//------------------------------------------------------------------------------
mXSize(xSize),
mYSize(ySize)
{
    mVertices = n_new(vector3[mXSize*mYSize]);
    mIndices = n_new(unsigned short[(mXSize-1)*(mYSize-1)*6]);

	mLast =0; //last wave used 
    
    unsigned int indexPos(0);
    unsigned short cornerVertex[4];
    unsigned short* currentSquare;
    for (unsigned int y = 0; y<mYSize-1; ++y)
    {
        for (unsigned int x = 0; x<mXSize-1; ++x)
        {
            // Indices of the corners of one square
            cornerVertex[0] = y*mXSize+x;
            cornerVertex[1] = cornerVertex[0]+1;
            cornerVertex[2] = cornerVertex[0]+mXSize+1;
            cornerVertex[3] = cornerVertex[2]-1;
     
            // Triangulate current square
            currentSquare = mIndices+indexPos;
            currentSquare[0] = cornerVertex[0];
            currentSquare[1] = cornerVertex[1];
            currentSquare[2] = cornerVertex[2];

            currentSquare[3] = cornerVertex[0];
            currentSquare[4] = cornerVertex[2];
            currentSquare[5] = cornerVertex[3];

            indexPos += 6;
        }
    }
}


GerstnerWaves::~GerstnerWaves()
{
n_printf("Gerstner~\n");
	if(this->mVertices != NULL)
		n_delete_array(this->mVertices);
	if(this->mIndices != NULL)
		n_delete_array(this->mIndices);
}

//------------------------------------------------------------------------------
unsigned int GerstnerWaves::getVertexCount() const
//------------------------------------------------------------------------------
{
    return mXSize*mYSize;
}

//------------------------------------------------------------------------------
vector3* GerstnerWaves::getVertices()
//------------------------------------------------------------------------------
{
    return mVertices;
}

//------------------------------------------------------------------------------
unsigned int GerstnerWaves::getIndexCount() const
//------------------------------------------------------------------------------
{
    return (mXSize-1)*(mYSize-1)*6;
}

//------------------------------------------------------------------------------
unsigned short* GerstnerWaves::getIndices()
//------------------------------------------------------------------------------
{
    return mIndices;
}

//------------------------------------------------------------------------------
void GerstnerWaves::addWave(const vector2& k, float length,
                            float amplitude, float phase)
//------------------------------------------------------------------------------
{
    Wave & w = mWaves[mLast%16];
    w.mK = k;
    w.mK.norm();
    w.mLength = (6.283185307179586476925286766559f)/length;
    w.mK *= w.mLength;
    w.mAmplitude = amplitude;
    w.mFrequency = n_sqrt(G*w.mLength);
    w.mPhase = phase;
	mLast++;
    //mWaves.push_back(w);
}

//------------------------------------------------------------------------------
void GerstnerWaves::update(const double& t)
//------------------------------------------------------------------------------
{
	float temp;
    for (unsigned int y = 0; y<mYSize; ++y)
    {
        unsigned int yLine = y*mXSize;
        for (unsigned int x = 0; x<mXSize; ++x)
        {
            vector2 deltaXZ(0, 0);
            float deltaY(0);
            // Center the water around (0, 0)
            vector2 x0(x,y);
            for (int i = 0; i<=mLast; ++i)
            {
                Wave& w = mWaves[i%16];
				//float temp = (w.mK*x0) - (w.mFrequency*t) + w.mPhase;    TMI implemented dotproduct on operator %
                temp = (w.mK%x0) - (w.mFrequency*t) + w.mPhase;
                deltaXZ += w.mK*(1.0f/w.mLength)*w.mAmplitude*n_sin(temp);
                deltaY += w.mAmplitude*n_cos(temp);
            }

            mVertices[yLine+x].x = x0.x - deltaXZ.x;
            mVertices[yLine+x].y = deltaY;
            mVertices[yLine+x].z = x0.y - deltaXZ.y;
        }
    }
}
